/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.monitor;

import datadog.trace.api.StatsDClient;
import ddtrot.dd.trace.api.cache.RadixTreeCache;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.org.jctools.counters.CountersFactory;
import ddtrot.org.jctools.counters.FixedSizeStripedLongCounter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntFunction;

public class TracerHealthMetrics
extends HealthMetrics
implements AutoCloseable {
    private static final IntFunction<String[]> STATUS_TAGS;
    private static final String[] NO_TAGS;
    private final RadixTreeCache<String[]> statusTagsCache = new RadixTreeCache<String[]>(16, 32, STATUS_TAGS, 200, 400);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile AgentTaskScheduler.Scheduled<TracerHealthMetrics> cancellation;
    private final FixedSizeStripedLongCounter userDropEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter userKeepEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter samplerDropEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter samplerKeepEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter unsetPriorityEnqueuedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter userDropDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter userKeepDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter samplerDropDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter samplerKeepDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter serialFailedDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter unsetPriorityDroppedTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter enqueuedSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter createdTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter createdSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter sampledSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter manualTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter cancelledContinuations = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter finishedContinuations = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter partialTraces = CountersFactory.createFixedSizeStripedCounter(8);
    private final FixedSizeStripedLongCounter droppedSpans = CountersFactory.createFixedSizeStripedCounter(8);
    private final StatsDClient statsd;
    private final long interval;
    private final TimeUnit units;

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.cancellation = AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(new Flush(), this, this.interval, this.interval, this.units);
        }
    }

    public TracerHealthMetrics(StatsDClient statsd) {
        this(statsd, 30L, TimeUnit.SECONDS);
    }

    public TracerHealthMetrics(StatsDClient statsd, long interval, TimeUnit units) {
        this.statsd = statsd;
        this.interval = interval;
        this.units = units;
    }

    @Override
    public void onStart(int queueCapacity) {
        this.statsd.gauge("queue.max_length", queueCapacity, NO_TAGS);
    }

    @Override
    public void onShutdown(boolean flushSuccess) {
    }

    @Override
    public void onPublish(List<DDSpan> trace, int samplingPriority) {
        switch (samplingPriority) {
            case -1: {
                this.userDropEnqueuedTraces.inc();
                break;
            }
            case 2: {
                this.userKeepEnqueuedTraces.inc();
                break;
            }
            case 0: {
                this.samplerDropEnqueuedTraces.inc();
                break;
            }
            case 1: {
                this.samplerKeepEnqueuedTraces.inc();
                break;
            }
            default: {
                this.unsetPriorityEnqueuedTraces.inc();
            }
        }
        this.enqueuedSpans.inc(trace.size());
    }

    @Override
    public void onFailedPublish(int samplingPriority) {
        switch (samplingPriority) {
            case -1: {
                this.userDropDroppedTraces.inc();
                break;
            }
            case 2: {
                this.userKeepDroppedTraces.inc();
                break;
            }
            case 0: {
                this.samplerDropDroppedTraces.inc();
                break;
            }
            case 1: {
                this.samplerKeepDroppedTraces.inc();
                break;
            }
            default: {
                this.unsetPriorityDroppedTraces.inc();
            }
        }
    }

    @Override
    public void onPartialPublish(int numberOfDroppedSpans) {
        this.partialTraces.inc();
        this.droppedSpans.inc(numberOfDroppedSpans);
    }

    @Override
    public void onScheduleFlush(boolean previousIncomplete) {
    }

    @Override
    public void onFlush(boolean early) {
    }

    @Override
    public void onPartialFlush(int sizeInBytes) {
        this.statsd.count("span.flushed.partial", sizeInBytes, NO_TAGS);
    }

    @Override
    public void onSerialize(int serializedSizeInBytes) {
        this.statsd.count("queue.enqueued.bytes", serializedSizeInBytes, NO_TAGS);
    }

    @Override
    public void onFailedSerialize(List<DDSpan> trace, Throwable optionalCause) {
        this.serialFailedDroppedTraces.inc();
    }

    @Override
    public void onCreateSpan() {
        this.createdSpans.inc();
    }

    @Override
    public void onCreateTrace() {
        this.createdTraces.inc();
    }

    @Override
    public void onCreateManualTrace() {
        this.manualTraces.inc();
    }

    @Override
    public void onCancelContinuation() {
        this.cancelledContinuations.inc();
    }

    @Override
    public void onFinishContinuation() {
        this.finishedContinuations.inc();
    }

    @Override
    public void onSend(int traceCount, int sizeInBytes, RemoteApi.Response response) {
        this.onSendAttempt(traceCount, sizeInBytes, response);
    }

    @Override
    public void onFailedSend(int traceCount, int sizeInBytes, RemoteApi.Response response) {
        this.onSendAttempt(traceCount, sizeInBytes, response);
    }

    private void onSendAttempt(int traceCount, int sizeInBytes, RemoteApi.Response response) {
        this.statsd.incrementCounter("api.requests.total", NO_TAGS);
        this.statsd.count("flush.traces.total", traceCount, NO_TAGS);
        this.statsd.count("flush.bytes.total", sizeInBytes, NO_TAGS);
        if (response.exception() != null) {
            this.statsd.incrementCounter("api.errors.total", NO_TAGS);
        }
        if (response.status() != null) {
            this.statsd.incrementCounter("api.responses.total", this.statusTagsCache.get(response.status()));
        }
    }

    @Override
    public void close() {
        if (null != this.cancellation) {
            this.cancellation.cancel();
        }
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class Flush
    implements AgentTaskScheduler.Task<TracerHealthMetrics> {
        private static final String[] USER_DROP_TAG = new String[]{"priority:user_drop"};
        private static final String[] USER_KEEP_TAG = new String[]{"priority:user_keep"};
        private static final String[] SAMPLER_DROP_TAG = new String[]{"priority:sampler_drop"};
        private static final String[] SAMPLER_KEEP_TAG = new String[]{"priority:sampler_keep"};
        private static final String[] SERIAL_FAILED_TAG = new String[]{"failure:serial"};
        private static final String[] UNSET_TAG = new String[]{"priority:unset"};

        private Flush() {
        }

        @Override
        public void run(TracerHealthMetrics target) {
            this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.userDropEnqueuedTraces, USER_DROP_TAG);
            this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.userKeepEnqueuedTraces, USER_KEEP_TAG);
            this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.samplerDropEnqueuedTraces, SAMPLER_DROP_TAG);
            this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.samplerKeepEnqueuedTraces, SAMPLER_KEEP_TAG);
            this.reportIfChanged(target.statsd, "queue.enqueued.traces", target.unsetPriorityEnqueuedTraces, UNSET_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.userDropDroppedTraces, USER_DROP_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.userKeepDroppedTraces, USER_KEEP_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.samplerDropDroppedTraces, SAMPLER_DROP_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.samplerKeepDroppedTraces, SAMPLER_KEEP_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.serialFailedDroppedTraces, SERIAL_FAILED_TAG);
            this.reportIfChanged(target.statsd, "queue.dropped.traces", target.unsetPriorityDroppedTraces, UNSET_TAG);
            this.reportIfChanged(target.statsd, "queue.enqueued.spans", target.enqueuedSpans, NO_TAGS);
            this.reportIfChanged(target.statsd, "trace.pending.created", target.createdTraces, NO_TAGS);
            this.reportIfChanged(target.statsd, "span.pending.created", target.createdSpans, NO_TAGS);
            this.reportIfChanged(target.statsd, "span.continuations.canceled", target.cancelledContinuations, NO_TAGS);
            this.reportIfChanged(target.statsd, "span.continuations.finished", target.finishedContinuations, NO_TAGS);
            this.reportIfChanged(target.statsd, "queue.partial.traces", target.partialTraces, NO_TAGS);
            this.reportIfChanged(target.statsd, "queue.dropped.spans", target.droppedSpans, NO_TAGS);
        }

        private void reportIfChanged(StatsDClient statsDClient, String aspect, FixedSizeStripedLongCounter counter, String[] tags) {
            long count = counter.getAndReset();
            if (count > 0L) {
                statsDClient.count(aspect, count, tags);
            }
        }
    }
}

