/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication;

import datadog.trace.api.Config;
import ddtrot.dd.communication.BackendApi;
import ddtrot.dd.communication.EvpProxyApi;
import ddtrot.dd.communication.IntakeApi;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.communication.http.HttpRetryPolicy;
import ddtrot.dd.trace.util.throwable.FatalAgentMisconfigurationError;
import ddtrot.okhttp3.HttpUrl;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendApiFactory {
    private static final Logger log = LoggerFactory.getLogger(BackendApiFactory.class);
    private final Config config;
    private final SharedCommunicationObjects sharedCommunicationObjects;

    public BackendApiFactory(Config config, SharedCommunicationObjects sharedCommunicationObjects) {
        this.config = config;
        this.sharedCommunicationObjects = sharedCommunicationObjects;
    }

    @Nullable
    public BackendApi createBackendApi(Intake intake) {
        HttpRetryPolicy.Factory retryPolicyFactory = new HttpRetryPolicy.Factory(5, 100, 2.0, true);
        if (intake.agentlessModeEnabled.apply(this.config).booleanValue()) {
            HttpUrl agentlessUrl = this.getAgentlessUrl(intake);
            String apiKey = this.config.getApiKey();
            if (apiKey == null || apiKey.isEmpty()) {
                throw new FatalAgentMisconfigurationError("Agentless mode is enabled and api key is not set. Please set application key");
            }
            String traceId = this.config.getIdGenerationStrategy().generateTraceId().toString();
            return new IntakeApi(agentlessUrl, apiKey, traceId, retryPolicyFactory, this.sharedCommunicationObjects.okHttpClient, true);
        }
        DDAgentFeaturesDiscovery featuresDiscovery = this.sharedCommunicationObjects.featuresDiscovery(this.config);
        featuresDiscovery.discoverIfOutdated();
        if (featuresDiscovery.supportsEvpProxy()) {
            String traceId = this.config.getIdGenerationStrategy().generateTraceId().toString();
            String evpProxyEndpoint = featuresDiscovery.getEvpProxyEndpoint();
            HttpUrl evpProxyUrl = this.sharedCommunicationObjects.agentUrl.resolve(evpProxyEndpoint);
            return new EvpProxyApi(traceId, evpProxyUrl, retryPolicyFactory, this.sharedCommunicationObjects.okHttpClient, true);
        }
        log.warn("Cannot create backend API client since agentless mode is disabled, and agent does not support EVP proxy");
        return null;
    }

    private HttpUrl getAgentlessUrl(Intake intake) {
        String customUrl = intake.customUrl.apply(this.config);
        if (customUrl != null && !customUrl.isEmpty()) {
            return HttpUrl.get(String.format("%s/api/%s/", customUrl, intake.version));
        }
        String site = this.config.getSite();
        return HttpUrl.get(String.format("https://%s.%s/api/%s/", intake.urlPrefix, site, intake.version));
    }

    public static enum Intake {
        API("api", "v2", Config::isCiVisibilityAgentlessEnabled, Config::getCiVisibilityAgentlessUrl),
        LOGS("http-intake.logs", "v2", Config::isAgentlessLogSubmissionEnabled, Config::getAgentlessLogSubmissionUrl);

        public final String urlPrefix;
        public final String version;
        public final Function<Config, Boolean> agentlessModeEnabled;
        public final Function<Config, String> customUrl;

        private Intake(String urlPrefix, String version, Function<Config, Boolean> agentlessModeEnabled, Function<Config, String> customUrl) {
            this.urlPrefix = urlPrefix;
            this.version = version;
            this.agentlessModeEnabled = agentlessModeEnabled;
            this.customUrl = customUrl;
        }
    }
}

