/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

import datadog.trace.context.TraceScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.util.AgentThreadFactory;
import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessSupervisor
implements Closeable {
    public static final HealthCheck ALWAYS_READY = health -> Health.READY_TO_START;
    private static final Logger log = LoggerFactory.getLogger(ProcessSupervisor.class);
    private static final long HEALTHY_DELAY_MILLIS = 10000L;
    private static final long FAULTED_DELAY_MILLIS = 2000L;
    private static final int MAX_FAULTS = 5;
    private final String imageName;
    private final ProcessBuilder processBuilder;
    private final HealthCheck healthCheck;
    private final Thread supervisorThread;
    private long nextCheckMillis = 0L;
    private Health currentHealth = Health.NEVER_CHECKED;
    private Process currentProcess;
    private int faults;
    private volatile boolean stopping = false;

    public ProcessSupervisor(String imageName, ProcessBuilder processBuilder) {
        this(imageName, processBuilder, ALWAYS_READY);
    }

    public ProcessSupervisor(String imageName, ProcessBuilder processBuilder, HealthCheck healthCheck) {
        this.imageName = imageName;
        this.processBuilder = processBuilder;
        this.healthCheck = healthCheck;
        this.supervisorThread = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.PROCESS_SUPERVISOR, this::mainLoop);
        this.supervisorThread.start();
    }

    private void mainLoop() {
        try {
            while (!this.stopping) {
                if (this.currentHealth == Health.FAULTED && ++this.faults >= 5) {
                    log.warn("Failed to start process [{}] after {} attempts", (Object)this.imageName, (Object)this.faults);
                    break;
                }
                try {
                    long delayMillis = this.nextCheckMillis - System.currentTimeMillis();
                    if (delayMillis > 0L) {
                        Thread.sleep(delayMillis);
                    }
                    this.currentHealth = this.healthCheck.run(this.currentHealth);
                    if (this.currentHealth == Health.READY_TO_START) {
                        this.startProcessAndWait();
                    }
                }
                catch (InterruptedException e) {
                    this.currentHealth = Health.INTERRUPTED;
                }
                catch (Throwable e) {
                    log.warn("Exception starting process: [{}]", (Object)this.imageName, (Object)e);
                    this.currentHealth = Health.FAULTED;
                }
                this.scheduleNextHealthCheck();
            }
        }
        finally {
            this.stopProcess();
        }
    }

    private void scheduleNextHealthCheck() {
        long now = System.currentTimeMillis();
        this.nextCheckMillis = this.currentHealth == Health.HEALTHY ? now + 10000L : (this.currentHealth == Health.FAULTED ? now + 2000L : Long.max(this.nextCheckMillis, now + 100L));
    }

    private void startProcessAndWait() throws Exception {
        if (this.currentProcess == null) {
            log.debug("Starting process: [{}]", (Object)this.imageName);
            try (TraceScope ignored = AgentTracer.get().muteTracing();){
                this.currentProcess = this.processBuilder.start();
            }
            this.currentHealth = Health.HEALTHY;
            this.faults = 0;
        }
        int code = this.currentProcess.waitFor();
        log.debug("Process [{}] has exited with code {}", (Object)this.imageName, (Object)code);
        this.currentHealth = code == 0 ? Health.INTERRUPTED : Health.FAULTED;
        this.currentProcess = null;
    }

    private void stopProcess() {
        if (this.currentProcess != null) {
            log.debug("Stopping process: [{}]", (Object)this.imageName);
            this.currentProcess.destroy();
            if (this.currentProcess.isAlive()) {
                this.currentProcess.destroyForcibly();
            }
            this.currentProcess = null;
        }
    }

    @Override
    public void close() {
        this.stopping = true;
        this.supervisorThread.interrupt();
        try {
            this.supervisorThread.join(800L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    Process getCurrentProcess() {
        return this.currentProcess;
    }

    @FunctionalInterface
    public static interface HealthCheck {
        public Health run(Health var1) throws InterruptedException;
    }

    public static enum Health {
        NEVER_CHECKED,
        READY_TO_START,
        INTERRUPTED,
        FAULTED,
        HEALTHY;

    }
}

