/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

import datadog.trace.api.Platform;
import datadog.trace.context.TraceScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.util.Strings;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressForbidden
public final class PidHelper {
    private static final Logger log = LoggerFactory.getLogger(PidHelper.class);
    private static final String PID = PidHelper.findPid();
    private static final long PID_AS_LONG = PidHelper.parsePid();

    public static String getPid() {
        return PID;
    }

    public static long getPidAsLong() {
        return PID_AS_LONG;
    }

    private static String findPid() {
        String pid = "";
        if (Platform.isJavaVersionAtLeast(9)) {
            try {
                pid = Strings.trim((String)((Supplier)Class.forName("ddtrot.dd.trace.util.JDK9PidSupplier").getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).get());
            }
            catch (Throwable e) {
                log.debug("JDK9PidSupplier not available", e);
            }
        }
        if (pid.isEmpty()) {
            try {
                String vmId = ManagementFactory.getRuntimeMXBean().getName();
                int pidEnd = vmId.indexOf(64);
                if (pidEnd > 0) {
                    pid = vmId.substring(0, pidEnd).trim();
                }
            }
            catch (Throwable e) {
                log.debug("Process id not available", e);
            }
        }
        return pid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> getJavaPids() {
        ProcessBuilder pb = new ProcessBuilder("jps");
        try (TraceScope ignored = AgentTracer.get().muteTracing();){
            Process p = pb.start();
            if (p.waitFor(500L, TimeUnit.MILLISECONDS)) {
                if (p.exitValue() != 0) {
                    log.debug("Execution of 'jps' failed with exit code {}", (Object)p.exitValue());
                    return Collections.emptySet();
                }
                try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    Set<String> set = br.lines().filter(l -> !l.contains("jps")).map(l -> {
                        int idx = l.indexOf(32);
                        return l.substring(0, idx);
                    }).collect(Collectors.toSet());
                    return set;
                }
            }
            log.debug("Execution of 'jps' timed out");
            return Collections.emptySet();
        }
        catch (Exception e) {
            log.debug("Unable to list java processes via 'jps'", (Throwable)e);
        }
        return Collections.emptySet();
    }

    private static long parsePid() {
        if (!PID.isEmpty()) {
            try {
                return Long.parseLong(PID);
            }
            catch (NumberFormatException e) {
                log.warn("Cannot parse PID {} as number. Default to 0", (Object)PID, (Object)e);
            }
        }
        return 0L;
    }
}

