/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.timgroup.statsd;

import java.nio.charset.StandardCharsets;

final class Utf8 {
    private static final int UTF8_REPLACEMENT_LENGTH = StandardCharsets.UTF_8.newEncoder().replacement().length;

    private Utf8() {
    }

    public static int encodedLength(CharSequence sequence) {
        int index;
        int utf16Length;
        int utf8Length = utf16Length = sequence.length();
        for (index = 0; index < utf16Length && sequence.charAt(index) < '\u0080'; ++index) {
        }
        while (index < utf16Length) {
            char character = sequence.charAt(index);
            if (character < '\u0800') {
                utf8Length += 127 - character >>> 31;
            } else {
                utf8Length += Utf8.encodedLengthGeneral(sequence, index);
                break;
            }
            ++index;
        }
        if (utf8Length < utf16Length) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)utf8Length + 0x100000000L));
        }
        return utf8Length;
    }

    private static int encodedLengthGeneral(CharSequence sequence, int start) {
        int utf16Length = sequence.length();
        int utf8Length = 0;
        for (int index = start; index < utf16Length; ++index) {
            char character = sequence.charAt(index);
            if (character < '\u0800') {
                utf8Length += 127 - character >>> 31;
                continue;
            }
            utf8Length += 2;
            if ('\ud800' > character || character > '\udfff') continue;
            if (Character.codePointAt(sequence, index) == character) {
                utf8Length += -2 + UTF8_REPLACEMENT_LENGTH - 1;
                continue;
            }
            ++index;
        }
        return utf8Length;
    }
}

