/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.api;

import datadog.trace.api.DDTraceId;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.TracePropagationStyle;
import datadog.trace.api.Tracer;
import datadog.trace.api.experimental.DataStreamsCheckpointer;
import datadog.trace.api.experimental.DataStreamsContextCarrier;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.api.internal.InternalTracer;
import datadog.trace.api.internal.TraceSegment;
import datadog.trace.api.sampling.SamplingRule;
import datadog.trace.context.TraceScope;
import ddtrot.dd.trace.api.EndpointCheckpointer;
import ddtrot.dd.trace.api.EndpointTracker;
import ddtrot.dd.trace.api.gateway.CallbackProvider;
import ddtrot.dd.trace.api.gateway.Flow;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.api.gateway.SubscriptionService;
import ddtrot.dd.trace.api.scopemanager.ScopeListener;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentDataStreamsMonitoring;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentHistogram;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTraceCollector;
import ddtrot.dd.trace.bootstrap.instrumentation.api.PathwayContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import ddtrot.dd.trace.bootstrap.instrumentation.api.Schema;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SchemaIterator;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeState;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeStateAware;
import ddtrot.dd.trace.bootstrap.instrumentation.api.StatsPoint;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class AgentTracer {
    private static final String DEFAULT_INSTRUMENTATION_NAME = "datadog";
    public static final TracerAPI NOOP_TRACER;
    private static volatile TracerAPI provider;

    @Deprecated
    public static AgentSpan startSpan(CharSequence spanName) {
        return AgentTracer.startSpan(DEFAULT_INSTRUMENTATION_NAME, spanName);
    }

    public static AgentSpan startSpan(String instrumentationName, CharSequence spanName) {
        return AgentTracer.get().startSpan(instrumentationName, spanName);
    }

    @Deprecated
    public static AgentSpan startSpan(CharSequence spanName, long startTimeMicros) {
        return AgentTracer.startSpan(DEFAULT_INSTRUMENTATION_NAME, spanName, startTimeMicros);
    }

    public static AgentSpan startSpan(String instrumentationName, CharSequence spanName, long startTimeMicros) {
        return AgentTracer.get().startSpan(instrumentationName, spanName, startTimeMicros);
    }

    @Deprecated
    public static AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent) {
        return AgentTracer.startSpan(DEFAULT_INSTRUMENTATION_NAME, spanName, parent);
    }

    public static AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpan.Context parent) {
        return AgentTracer.get().startSpan(instrumentationName, spanName, parent);
    }

    @Deprecated
    public static AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, long startTimeMicros) {
        return AgentTracer.startSpan(DEFAULT_INSTRUMENTATION_NAME, spanName, parent, startTimeMicros);
    }

    public static AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpan.Context parent, long startTimeMicros) {
        return AgentTracer.get().startSpan(instrumentationName, spanName, parent, startTimeMicros);
    }

    public static AgentScope activateSpan(AgentSpan span) {
        return AgentTracer.get().activateSpan(span, ScopeSource.INSTRUMENTATION, true);
    }

    public static AgentScope activateSpan(AgentSpan span, boolean isAsyncPropagating) {
        return AgentTracer.get().activateSpan(span, ScopeSource.INSTRUMENTATION, isAsyncPropagating);
    }

    public static AgentScope.Continuation captureSpan(AgentSpan span) {
        return AgentTracer.get().captureSpan(span);
    }

    public static void closePrevious(boolean finishSpan) {
        AgentTracer.get().closePrevious(finishSpan);
    }

    public static AgentScope activateNext(AgentSpan span) {
        return AgentTracer.get().activateNext(span);
    }

    public static TraceConfig traceConfig(AgentSpan span) {
        return null != span ? span.traceConfig() : AgentTracer.traceConfig();
    }

    public static TraceConfig traceConfig() {
        return AgentTracer.get().captureTraceConfig();
    }

    public static AgentSpan activeSpan() {
        return AgentTracer.get().activeSpan();
    }

    public static AgentScope activeScope() {
        return AgentTracer.get().activeScope();
    }

    public static AgentScope.Continuation capture() {
        AgentScope activeScope = AgentTracer.activeScope();
        return activeScope == null ? null : activeScope.capture();
    }

    public static AgentPropagation propagate() {
        return AgentTracer.get().propagate();
    }

    public static AgentSpan noopSpan() {
        return AgentTracer.get().noopSpan();
    }

    public static AgentSpan blackholeSpan() {
        return AgentTracer.get().blackholeSpan();
    }

    public static boolean isRegistered() {
        return provider != NOOP_TRACER;
    }

    public static synchronized void registerIfAbsent(TracerAPI tracer) {
        if (tracer != null && tracer != NOOP_TRACER) {
            provider = tracer;
        }
    }

    public static synchronized void forceRegister(TracerAPI tracer) {
        provider = tracer;
    }

    public static TracerAPI get() {
        return provider;
    }

    private AgentTracer() {
    }

    static {
        provider = NOOP_TRACER = new NoopTracerAPI();
    }

    public static final class NoopTraceConfig
    implements TraceConfig {
        public static final NoopTraceConfig INSTANCE = new NoopTraceConfig();

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public boolean isRuntimeMetricsEnabled() {
            return false;
        }

        @Override
        public boolean isLogsInjectionEnabled() {
            return false;
        }

        @Override
        public boolean isDataStreamsEnabled() {
            return false;
        }

        @Override
        public Map<String, String> getServiceMapping() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getRequestHeaderTags() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getResponseHeaderTags() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getBaggageMapping() {
            return Collections.emptyMap();
        }

        @Override
        public Double getTraceSampleRate() {
            return null;
        }

        @Override
        public Map<String, String> getTracingTags() {
            return Collections.emptyMap();
        }

        @Override
        public String getPreferredServiceName() {
            return null;
        }

        @Override
        public List<? extends SamplingRule.SpanSamplingRule> getSpanSamplingRules() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends SamplingRule.TraceSamplingRule> getTraceSamplingRules() {
            return Collections.emptyList();
        }
    }

    public static class NoopAgentHistogram
    implements AgentHistogram {
        public static final NoopAgentHistogram INSTANCE = new NoopAgentHistogram();

        @Override
        public double getCount() {
            return 0.0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void accept(double value) {
        }

        @Override
        public void accept(double value, double count) {
        }

        @Override
        public double getValueAtQuantile(double quantile) {
            return 0.0;
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return 0.0;
        }

        @Override
        public void clear() {
        }

        @Override
        public ByteBuffer serialize() {
            return null;
        }
    }

    public static class NoopPathwayContext
    implements PathwayContext {
        public static final NoopPathwayContext INSTANCE = new NoopPathwayContext();

        @Override
        public boolean isStarted() {
            return false;
        }

        @Override
        public long getHash() {
            return 0L;
        }

        @Override
        public void setCheckpoint(LinkedHashMap<String, String> sortedTags, Consumer<StatsPoint> pointConsumer, long defaultTimestamp, long payloadSizeBytes) {
        }

        @Override
        public void setCheckpoint(LinkedHashMap<String, String> sortedTags, Consumer<StatsPoint> pointConsumer, long defaultTimestamp) {
        }

        @Override
        public void setCheckpoint(LinkedHashMap<String, String> sortedTags, Consumer<StatsPoint> pointConsumer) {
        }

        @Override
        public void saveStats(StatsPoint point) {
        }

        @Override
        public StatsPoint getSavedStats() {
            return null;
        }

        @Override
        public byte[] encode() {
            return null;
        }

        @Override
        public String strEncode() {
            return null;
        }
    }

    public static class NoopAgentDataStreamsMonitoring
    implements AgentDataStreamsMonitoring {
        public static final NoopAgentDataStreamsMonitoring INSTANCE = new NoopAgentDataStreamsMonitoring();

        @Override
        public void trackBacklog(LinkedHashMap<String, String> sortedTags, long value) {
        }

        @Override
        public void setCheckpoint(AgentSpan span, LinkedHashMap<String, String> sortedTags, long defaultTimestamp, long payloadSizeBytes) {
        }

        @Override
        public PathwayContext newPathwayContext() {
            return NoopPathwayContext.INSTANCE;
        }

        @Override
        public void add(StatsPoint statsPoint) {
        }

        @Override
        public int trySampleSchema(String topic) {
            return 0;
        }

        @Override
        public boolean canSampleSchema(String topic) {
            return false;
        }

        @Override
        public Schema getSchema(String schemaName, SchemaIterator iterator) {
            return null;
        }

        @Override
        public void setProduceCheckpoint(String type, String target) {
        }

        public void setConsumeCheckpoint(String type, String source, DataStreamsContextCarrier carrier) {
        }

        public void setProduceCheckpoint(String type, String target, DataStreamsContextCarrier carrier) {
        }
    }

    public static class NoopAgentTraceCollector
    implements AgentTraceCollector {
        public static final NoopAgentTraceCollector INSTANCE = new NoopAgentTraceCollector();

        @Override
        public void registerContinuation(AgentScope.Continuation continuation) {
        }

        @Override
        public void cancelContinuation(AgentScope.Continuation continuation) {
        }
    }

    public static class NoopContext
    implements AgentSpan.Context.Extracted {
        public static final NoopContext INSTANCE = new NoopContext();

        private NoopContext() {
        }

        @Override
        public DDTraceId getTraceId() {
            return DDTraceId.ZERO;
        }

        @Override
        public long getSpanId() {
            return 0L;
        }

        @Override
        public AgentTraceCollector getTraceCollector() {
            return NoopAgentTraceCollector.INSTANCE;
        }

        @Override
        public int getSamplingPriority() {
            return -128;
        }

        @Override
        public Iterable<Map.Entry<String, String>> baggageItems() {
            return Collections.emptyList();
        }

        @Override
        public PathwayContext getPathwayContext() {
            return NoopPathwayContext.INSTANCE;
        }

        @Override
        public List<AgentSpanLink> getTerminatedContextLinks() {
            return Collections.emptyList();
        }

        @Override
        public String getForwarded() {
            return null;
        }

        @Override
        public String getFastlyClientIp() {
            return null;
        }

        @Override
        public String getCfConnectingIp() {
            return null;
        }

        @Override
        public String getCfConnectingIpv6() {
            return null;
        }

        @Override
        public String getXForwardedProto() {
            return null;
        }

        @Override
        public String getXForwardedHost() {
            return null;
        }

        @Override
        public String getXForwardedPort() {
            return null;
        }

        @Override
        public String getForwardedFor() {
            return null;
        }

        @Override
        public String getXForwarded() {
            return null;
        }

        @Override
        public String getXForwardedFor() {
            return null;
        }

        @Override
        public String getXClusterClientIp() {
            return null;
        }

        @Override
        public String getXRealIp() {
            return null;
        }

        @Override
        public String getXClientIp() {
            return null;
        }

        @Override
        public String getUserAgent() {
            return null;
        }

        @Override
        public String getTrueClientIp() {
            return null;
        }

        @Override
        public String getCustomIpHeader() {
            return null;
        }
    }

    public static final class BlackholeContext
    extends NoopContext {
        public static final BlackholeContext INSTANCE = new BlackholeContext();

        private BlackholeContext() {
        }
    }

    static class NoopContinuation
    implements AgentScope.Continuation {
        static final NoopContinuation INSTANCE = new NoopContinuation();

        NoopContinuation() {
        }

        @Override
        public AgentScope activate() {
            return NoopAgentScope.INSTANCE;
        }

        public void cancel() {
        }

        @Override
        public AgentSpan getSpan() {
            return NoopAgentSpan.INSTANCE;
        }
    }

    static class NoopAgentPropagation
    implements AgentPropagation {
        static final NoopAgentPropagation INSTANCE = new NoopAgentPropagation();

        NoopAgentPropagation() {
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, TracePropagationStyle style) {
        }

        @Override
        public <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags) {
        }

        @Override
        public <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags, long defaultTimestamp, long payloadSizeBytes) {
        }

        @Override
        public <C> void injectPathwayContextWithoutSendingStats(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags) {
        }

        @Override
        public <C> AgentSpan.Context.Extracted extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            return NoopContext.INSTANCE;
        }
    }

    public static final class NoopAgentScope
    implements AgentScope {
        public static final NoopAgentScope INSTANCE = new NoopAgentScope();

        private NoopAgentScope() {
        }

        @Override
        public AgentSpan span() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public byte source() {
            return 0;
        }

        @Override
        public void setAsyncPropagation(boolean value) {
        }

        @Override
        public AgentScope.Continuation capture() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public AgentScope.Continuation captureConcurrent() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public void close() {
        }

        public boolean isAsyncPropagating() {
            return false;
        }
    }

    public static class NoopAgentSpan
    implements AgentSpan {
        public static final NoopAgentSpan INSTANCE = new NoopAgentSpan();

        private NoopAgentSpan() {
        }

        @Override
        public DDTraceId getTraceId() {
            return DDTraceId.ZERO;
        }

        @Override
        public long getSpanId() {
            return 0L;
        }

        @Override
        public AgentSpan setTag(String key, boolean value) {
            return this;
        }

        @Override
        public void setRequestBlockingAction(Flow.Action.RequestBlockingAction rba) {
        }

        @Override
        public Flow.Action.RequestBlockingAction getRequestBlockingAction() {
            return null;
        }

        @Override
        public AgentSpan setTag(String tag, Number value) {
            return this;
        }

        public boolean isError() {
            return false;
        }

        @Override
        public AgentSpan setTag(String key, int value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, long value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, double value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, Object value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, int value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, long value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, double value) {
            return this;
        }

        @Override
        public Object getTag(String key) {
            return null;
        }

        public long getStartTime() {
            return 0L;
        }

        public long getDurationNano() {
            return 0L;
        }

        public String getOperationName() {
            return null;
        }

        public AgentSpan setOperationName(CharSequence serviceName) {
            return this;
        }

        public String getServiceName() {
            return null;
        }

        public AgentSpan setServiceName(String serviceName) {
            return this;
        }

        public CharSequence getResourceName() {
            return null;
        }

        @Override
        public AgentSpan setResourceName(CharSequence resourceName) {
            return this;
        }

        @Override
        public AgentSpan setResourceName(CharSequence resourceName, byte priority) {
            return this;
        }

        @Override
        public boolean eligibleForDropping() {
            return true;
        }

        @Override
        public RequestContext getRequestContext() {
            return RequestContext.Noop.INSTANCE;
        }

        @Override
        public Integer forceSamplingDecision() {
            return null;
        }

        @Override
        public AgentSpan setSamplingPriority(int newPriority, int samplingMechanism) {
            return this;
        }

        public Integer getSamplingPriority() {
            return -128;
        }

        public AgentSpan setSamplingPriority(int newPriority) {
            return this;
        }

        public String getSpanType() {
            return null;
        }

        @Override
        public AgentSpan setSpanType(CharSequence type) {
            return this;
        }

        @Override
        public Map<String, Object> getTags() {
            return Collections.emptyMap();
        }

        @Override
        public AgentSpan setTag(String key, String value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, CharSequence value) {
            return this;
        }

        @Override
        public AgentSpan setError(boolean error) {
            return this;
        }

        @Override
        public AgentSpan setError(boolean error, byte priority) {
            return this;
        }

        @Override
        public AgentSpan setMeasured(boolean measured) {
            return this;
        }

        public AgentSpan getRootSpan() {
            return this;
        }

        @Override
        public AgentSpan setErrorMessage(String errorMessage) {
            return this;
        }

        @Override
        public AgentSpan addThrowable(Throwable throwable) {
            return this;
        }

        @Override
        public AgentSpan addThrowable(Throwable throwable, byte errorPriority) {
            return this;
        }

        @Override
        public AgentSpan setHttpStatusCode(int statusCode) {
            return this;
        }

        @Override
        public short getHttpStatusCode() {
            return 0;
        }

        @Override
        public AgentSpan getLocalRootSpan() {
            return this;
        }

        @Override
        public boolean isSameTrace(AgentSpan otherSpan) {
            return otherSpan == INSTANCE;
        }

        @Override
        public AgentSpan.Context context() {
            return NoopContext.INSTANCE;
        }

        @Override
        public String getBaggageItem(String key) {
            return null;
        }

        @Override
        public AgentSpan setBaggageItem(String key, String value) {
            return this;
        }

        @Override
        public void finish() {
        }

        @Override
        public void finish(long finishMicros) {
        }

        @Override
        public void finishWithDuration(long durationNanos) {
        }

        @Override
        public void beginEndToEnd() {
        }

        @Override
        public void finishWithEndToEnd() {
        }

        @Override
        public boolean phasedFinish() {
            return false;
        }

        @Override
        public void publish() {
        }

        @Override
        public String getSpanName() {
            return "";
        }

        @Override
        public void setSpanName(CharSequence spanName) {
        }

        @Override
        public boolean hasResourceName() {
            return false;
        }

        @Override
        public byte getResourceNamePriority() {
            return 127;
        }

        @Override
        public TraceConfig traceConfig() {
            return NoopTraceConfig.INSTANCE;
        }

        @Override
        public void addLink(AgentSpanLink link) {
        }

        @Override
        public AgentSpan setMetaStruct(String field, Object value) {
            return this;
        }

        @Override
        public boolean isOutbound() {
            return false;
        }

        @Override
        public boolean isRequiresPostProcessing() {
            return false;
        }
    }

    public static final class BlackholeAgentSpan
    extends NoopAgentSpan {
        private final DDTraceId ddTraceId;

        public BlackholeAgentSpan(DDTraceId ddTraceId) {
            this.ddTraceId = ddTraceId;
        }

        @Override
        public boolean isSameTrace(AgentSpan otherSpan) {
            return otherSpan != null && (this.ddTraceId != null && this.ddTraceId.equals(otherSpan.getTraceId()) || otherSpan.getTraceId() == null);
        }

        @Override
        public DDTraceId getTraceId() {
            return this.ddTraceId;
        }

        @Override
        public AgentSpan.Context context() {
            return BlackholeContext.INSTANCE;
        }
    }

    static class NoopTracerAPI
    implements TracerAPI {
        protected NoopTracerAPI() {
        }

        @Override
        public AgentSpan startSpan(String instrumentationName, CharSequence spanName) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String instrumentationName, CharSequence spanName, long startTimeMicros) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpan.Context parent) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpan.Context parent, long startTimeMicros) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentScope activateSpan(AgentSpan span, ScopeSource source) {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public AgentScope activateSpan(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public AgentScope.Continuation captureSpan(AgentSpan span) {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public void closePrevious(boolean finishSpan) {
        }

        @Override
        public AgentScope activateNext(AgentSpan span) {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public AgentSpan activeSpan() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentScope activeScope() {
            return null;
        }

        @Override
        public AgentPropagation propagate() {
            return NoopAgentPropagation.INSTANCE;
        }

        @Override
        public AgentSpan noopSpan() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan blackholeSpan() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public SpanBuilder buildSpan(String instrumentationName, CharSequence spanName) {
            return null;
        }

        @Override
        public void close() {
        }

        public void addScopeListener(Runnable afterScopeActivatedCallback, Runnable afterScopeClosedCallback) {
        }

        public void flush() {
        }

        public void flushMetrics() {
        }

        @Override
        public ProfilingContextIntegration getProfilingContext() {
            return ProfilingContextIntegration.NoOp.INSTANCE;
        }

        public TraceSegment getTraceSegment() {
            return null;
        }

        public String getTraceId() {
            return null;
        }

        public String getSpanId() {
            return null;
        }

        @Override
        public String getTraceId(AgentSpan span) {
            return null;
        }

        @Override
        public String getSpanId(AgentSpan span) {
            return null;
        }

        public boolean addTraceInterceptor(TraceInterceptor traceInterceptor) {
            return false;
        }

        public TraceScope muteTracing() {
            return NoopAgentScope.INSTANCE;
        }

        public DataStreamsCheckpointer getDataStreamsCheckpointer() {
            return this.getDataStreamsMonitoring();
        }

        @Override
        public void addScopeListener(ScopeListener listener) {
        }

        @Override
        public SubscriptionService getSubscriptionService(RequestContextSlot slot) {
            return SubscriptionService.SubscriptionServiceNoop.INSTANCE;
        }

        @Override
        public CallbackProvider getCallbackProvider(RequestContextSlot slot) {
            return CallbackProvider.CallbackProviderNoop.INSTANCE;
        }

        @Override
        public CallbackProvider getUniversalCallbackProvider() {
            return CallbackProvider.CallbackProviderNoop.INSTANCE;
        }

        @Override
        public void onRootSpanFinished(AgentSpan root, EndpointTracker tracker) {
        }

        @Override
        public EndpointTracker onRootSpanStarted(AgentSpan root) {
            return EndpointTracker.NO_OP;
        }

        @Override
        public AgentSpan.Context notifyExtensionStart(Object event) {
            return null;
        }

        @Override
        public void notifyExtensionEnd(AgentSpan span, Object result, boolean isError) {
        }

        @Override
        public ScopeState newScopeState() {
            return null;
        }

        @Override
        public AgentDataStreamsMonitoring getDataStreamsMonitoring() {
            return NoopAgentDataStreamsMonitoring.INSTANCE;
        }

        @Override
        public TraceConfig captureTraceConfig() {
            return NoopTraceConfig.INSTANCE;
        }

        @Override
        public AgentHistogram newHistogram(double relativeAccuracy, int maxNumBins) {
            return NoopAgentHistogram.INSTANCE;
        }

        @Override
        public void updatePreferredServiceName(String serviceName) {
        }
    }

    public static interface SpanBuilder {
        public AgentSpan start();

        public SpanBuilder asChildOf(AgentSpan.Context var1);

        public SpanBuilder ignoreActiveSpan();

        public SpanBuilder withTag(String var1, String var2);

        public SpanBuilder withTag(String var1, boolean var2);

        public SpanBuilder withTag(String var1, Number var2);

        public SpanBuilder withTag(String var1, Object var2);

        public SpanBuilder withStartTimestamp(long var1);

        public SpanBuilder withServiceName(String var1);

        public SpanBuilder withResourceName(String var1);

        public SpanBuilder withErrorFlag();

        public SpanBuilder withSpanType(CharSequence var1);

        public <T> SpanBuilder withRequestContextData(RequestContextSlot var1, T var2);

        public SpanBuilder withLink(AgentSpanLink var1);

        public SpanBuilder withSpanId(long var1);
    }

    public static interface TracerAPI
    extends Tracer,
    InternalTracer,
    EndpointCheckpointer,
    ScopeStateAware {
        public AgentSpan startSpan(String var1, CharSequence var2);

        public AgentSpan startSpan(String var1, CharSequence var2, long var3);

        public AgentSpan startSpan(String var1, CharSequence var2, AgentSpan.Context var3);

        public AgentSpan startSpan(String var1, CharSequence var2, AgentSpan.Context var3, long var4);

        public AgentScope activateSpan(AgentSpan var1, ScopeSource var2);

        public AgentScope activateSpan(AgentSpan var1, ScopeSource var2, boolean var3);

        public AgentScope.Continuation captureSpan(AgentSpan var1);

        public void closePrevious(boolean var1);

        public AgentScope activateNext(AgentSpan var1);

        public AgentSpan activeSpan();

        public AgentScope activeScope();

        public AgentPropagation propagate();

        public AgentSpan noopSpan();

        public AgentSpan blackholeSpan();

        @Deprecated
        default public SpanBuilder buildSpan(CharSequence spanName) {
            return this.buildSpan(AgentTracer.DEFAULT_INSTRUMENTATION_NAME, spanName);
        }

        public SpanBuilder buildSpan(String var1, CharSequence var2);

        public void close();

        public void addScopeListener(ScopeListener var1);

        public SubscriptionService getSubscriptionService(RequestContextSlot var1);

        public CallbackProvider getCallbackProvider(RequestContextSlot var1);

        public CallbackProvider getUniversalCallbackProvider();

        public AgentSpan.Context notifyExtensionStart(Object var1);

        public void notifyExtensionEnd(AgentSpan var1, Object var2, boolean var3);

        public AgentDataStreamsMonitoring getDataStreamsMonitoring();

        public String getTraceId(AgentSpan var1);

        public String getSpanId(AgentSpan var1);

        public TraceConfig captureTraceConfig();

        public ProfilingContextIntegration getProfilingContext();

        public AgentHistogram newHistogram(double var1, int var3);

        public void updatePreferredServiceName(String var1);
    }
}

