/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import datadog.trace.api.Config;
import ddtrot.dd.communication.ddagent.DroppingPolicy;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.trace.api.civisibility.CiVisibilityWellKnownTags;
import ddtrot.dd.trace.api.intake.TrackType;
import ddtrot.dd.trace.common.sampling.SingleSpanSampler;
import ddtrot.dd.trace.common.writer.CompositePayloadDispatcher;
import ddtrot.dd.trace.common.writer.PayloadDispatcher;
import ddtrot.dd.trace.common.writer.PayloadDispatcherImpl;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.common.writer.RemoteWriter;
import ddtrot.dd.trace.common.writer.TraceProcessingWorker;
import ddtrot.dd.trace.common.writer.ddagent.Prioritization;
import ddtrot.dd.trace.common.writer.ddintake.DDIntakeMapperDiscovery;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DDIntakeWriter
extends RemoteWriter {
    public static final String DEFAULT_INTAKE_VERSION = "v2";
    public static final long DEFAULT_INTAKE_TIMEOUT = 10L;
    private static final int BUFFER_SIZE = 1024;

    public static DDIntakeWriterBuilder builder() {
        return new DDIntakeWriterBuilder();
    }

    DDIntakeWriter(TraceProcessingWorker worker, PayloadDispatcher dispatcher, HealthMetrics healthMetrics, int flushTimeout, TimeUnit flushTimeoutUnit, boolean alwaysFlush) {
        super(worker, dispatcher, healthMetrics, flushTimeout, flushTimeoutUnit, alwaysFlush);
    }

    DDIntakeWriter(TraceProcessingWorker worker, PayloadDispatcher dispatcher, HealthMetrics healthMetrics, boolean alwaysFlush) {
        super(worker, dispatcher, healthMetrics, alwaysFlush);
    }

    public static class DDIntakeWriterBuilder {
        CiVisibilityWellKnownTags wellKnownTags = Config.get().getCiVisibilityWellKnownTags();
        int traceBufferSize = 1024;
        HealthMetrics healthMetrics = HealthMetrics.NO_OP;
        int flushIntervalMilliseconds = 1000;
        Monitoring monitoring = Monitoring.DISABLED;
        DroppingPolicy droppingPolicy = DroppingPolicy.DISABLED;
        Prioritization prioritization = Prioritization.FAST_LANE;
        private int flushTimeout = 5;
        private TimeUnit flushTimeoutUnit = TimeUnit.SECONDS;
        private boolean alwaysFlush = false;
        private final Map<TrackType, RemoteApi> tracks = new EnumMap<TrackType, RemoteApi>(TrackType.class);
        private SingleSpanSampler singleSpanSampler;

        public DDIntakeWriterBuilder addTrack(TrackType trackType, RemoteApi intakeApi) {
            this.tracks.put(trackType, intakeApi);
            return this;
        }

        public DDIntakeWriterBuilder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public DDIntakeWriterBuilder traceBufferSize(int traceBufferSize) {
            this.traceBufferSize = traceBufferSize;
            return this;
        }

        public DDIntakeWriterBuilder healthMetrics(HealthMetrics healthMetrics) {
            this.healthMetrics = healthMetrics;
            return this;
        }

        public DDIntakeWriterBuilder flushIntervalMilliseconds(int flushIntervalMilliseconds) {
            this.flushIntervalMilliseconds = flushIntervalMilliseconds;
            return this;
        }

        public DDIntakeWriterBuilder prioritization(Prioritization prioritization) {
            this.prioritization = prioritization;
            return this;
        }

        public DDIntakeWriterBuilder droppingPolicy(DroppingPolicy droppingPolicy) {
            this.droppingPolicy = droppingPolicy;
            return this;
        }

        public DDIntakeWriterBuilder wellKnownTags(CiVisibilityWellKnownTags wellKnownTags) {
            this.wellKnownTags = wellKnownTags;
            return this;
        }

        public DDIntakeWriterBuilder alwaysFlush(boolean alwaysFlush) {
            this.alwaysFlush = alwaysFlush;
            return this;
        }

        public DDIntakeWriterBuilder flushTimeout(int flushTimeout, TimeUnit flushTimeoutUnit) {
            this.flushTimeout = flushTimeout;
            this.flushTimeoutUnit = flushTimeoutUnit;
            return this;
        }

        public DDIntakeWriterBuilder singleSpanSampler(SingleSpanSampler singleSpanSampler) {
            this.singleSpanSampler = singleSpanSampler;
            return this;
        }

        public DDIntakeWriter build() {
            PayloadDispatcher dispatcher;
            if (this.tracks.isEmpty()) {
                throw new IllegalArgumentException("At least one track needs to be configured");
            }
            if (this.tracks.size() == 1) {
                dispatcher = this.createDispatcher(this.tracks.entrySet().iterator().next());
            } else {
                PayloadDispatcher[] dispatchers = (PayloadDispatcher[])this.tracks.entrySet().stream().map(this::createDispatcher).toArray(PayloadDispatcher[]::new);
                dispatcher = new CompositePayloadDispatcher(dispatchers);
            }
            TraceProcessingWorker traceProcessingWorker = new TraceProcessingWorker(this.traceBufferSize, this.healthMetrics, dispatcher, this.droppingPolicy, this.prioritization, this.flushIntervalMilliseconds, TimeUnit.MILLISECONDS, this.singleSpanSampler, null);
            return new DDIntakeWriter(traceProcessingWorker, dispatcher, this.healthMetrics, this.flushTimeout, this.flushTimeoutUnit, this.alwaysFlush);
        }

        private PayloadDispatcher createDispatcher(Map.Entry<TrackType, RemoteApi> e) {
            TrackType trackType = e.getKey();
            RemoteApi intakeApi = e.getValue();
            DDIntakeMapperDiscovery mapperDiscovery = new DDIntakeMapperDiscovery(trackType, this.wellKnownTags, intakeApi.isCompressionEnabled());
            return new PayloadDispatcherImpl(mapperDiscovery, intakeApi, this.healthMetrics, this.monitoring);
        }
    }
}

