/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import datadog.trace.api.Config;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.trace.common.sampling.Sampler;
import ddtrot.dd.trace.common.sampling.SingleSpanSampler;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.common.writer.WriterFactory;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import java.util.List;
import java.util.regex.Pattern;

public class MultiWriter
implements Writer {
    private static final Pattern MW_PATTERN = Pattern.compile("MultiWriter:", 16);
    private static final Pattern COMMA_PATTERN = Pattern.compile(",", 16);
    private final Writer[] writers;

    public MultiWriter(Config config, SharedCommunicationObjects commObjects, Sampler sampler, SingleSpanSampler singleSpanSampler, HealthMetrics healthMetrics, String type) {
        String mwConfig = MW_PATTERN.matcher(type).replaceAll("");
        String[] writerConfigs = COMMA_PATTERN.split(mwConfig);
        this.writers = new Writer[writerConfigs.length];
        int i = 0;
        for (String writerConfig : writerConfigs) {
            this.writers[i] = WriterFactory.createWriter(config, commObjects, sampler, singleSpanSampler, healthMetrics, writerConfig);
            ++i;
        }
    }

    public MultiWriter(Writer[] writers) {
        this.writers = (Writer[])writers.clone();
    }

    @Override
    public void start() {
        for (Writer writer : this.writers) {
            if (writer == null) continue;
            writer.start();
        }
    }

    @Override
    public void write(List<DDSpan> trace) {
        for (Writer writer : this.writers) {
            if (writer == null) continue;
            writer.write(trace);
        }
    }

    @Override
    public boolean flush() {
        boolean flush = true;
        for (Writer writer : this.writers) {
            if (writer == null) continue;
            flush &= writer.flush();
        }
        return flush;
    }

    @Override
    public void close() {
        for (Writer writer : this.writers) {
            if (writer == null) continue;
            writer.close();
        }
    }

    @Override
    public void incrementDropCounts(int spanCount) {
        for (Writer writer : this.writers) {
            if (writer == null) continue;
            writer.incrementDropCounts(spanCount);
        }
    }
}

