/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.tagprocessor;

import datadog.trace.api.Config;
import ddtrot.dd.trace.core.tagprocessor.BaseServiceAdder;
import ddtrot.dd.trace.core.tagprocessor.PayloadTagsProcessor;
import ddtrot.dd.trace.core.tagprocessor.PeerServiceCalculator;
import ddtrot.dd.trace.core.tagprocessor.PostProcessorChain;
import ddtrot.dd.trace.core.tagprocessor.QueryObfuscator;
import ddtrot.dd.trace.core.tagprocessor.RemoteHostnameAdder;
import ddtrot.dd.trace.core.tagprocessor.TagsPostProcessor;
import java.util.ArrayList;

public final class TagsPostProcessorFactory {
    private static boolean addBaseService = true;
    private static boolean addRemoteHostname = true;

    public static TagsPostProcessor instance() {
        return Lazy.instance;
    }

    public static void withAddBaseService(boolean enabled) {
        addBaseService = enabled;
        Lazy.instance = Lazy.create();
    }

    public static void withAddRemoteHostname(boolean enabled) {
        addRemoteHostname = enabled;
        Lazy.instance = Lazy.create();
    }

    public static void reset() {
        TagsPostProcessorFactory.withAddBaseService(true);
        TagsPostProcessorFactory.withAddRemoteHostname(true);
    }

    private static class Lazy {
        private static TagsPostProcessor instance = Lazy.create();

        private Lazy() {
        }

        private static TagsPostProcessor create() {
            PayloadTagsProcessor ptp;
            ArrayList<TagsPostProcessor> processors = new ArrayList<TagsPostProcessor>(4);
            processors.add(new PeerServiceCalculator());
            if (addBaseService) {
                processors.add(new BaseServiceAdder(Config.get().getServiceName()));
            }
            processors.add(new QueryObfuscator(Config.get().getObfuscationQueryRegexp()));
            if (addRemoteHostname) {
                processors.add(new RemoteHostnameAdder(Config.get().getHostNameSupplier()));
            }
            if (Config.get().isCloudPayloadTaggingEnabled() && (ptp = PayloadTagsProcessor.create(Config.get())) != null) {
                processors.add(ptp);
            }
            return new PostProcessorChain(processors.toArray(processors.toArray(new TagsPostProcessor[0])));
        }
    }
}

