/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util.stacktrace;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.util.stacktrace.AbstractStackWalker;
import ddtrot.dd.trace.util.stacktrace.StackTraceEvent;
import ddtrot.dd.trace.util.stacktrace.StackTraceFrame;
import ddtrot.dd.trace.util.stacktrace.StackWalkerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class StackUtils {
    public static final String META_STRUCT_KEY = "_dd.stack";

    public static <E extends Throwable> E update(E exception, Function<StackTraceElement[], StackTraceElement[]> filter) {
        StackTraceElement[] stack = exception.getStackTrace();
        exception.setStackTrace(filter.apply(stack));
        return exception;
    }

    public static <E extends Throwable> E filter(E exception, Predicate<StackTraceElement> filter) {
        return StackUtils.update(exception, stack -> (StackTraceElement[])Arrays.stream(stack).filter(filter).toArray(StackTraceElement[]::new));
    }

    public static <E extends Throwable> E filterFirst(E exception, Predicate<StackTraceElement> filter) {
        return StackUtils.filter(exception, new OneTimePredicate<StackTraceElement>(filter));
    }

    public static <E extends Throwable> E filterDatadog(E exception) {
        return StackUtils.filter(exception, AbstractStackWalker::isNotDatadogTraceStackElement);
    }

    public static <E extends Throwable> E filterFirstDatadog(E exception) {
        return StackUtils.filterFirst(exception, AbstractStackWalker::isNotDatadogTraceStackElement);
    }

    public static <E extends Throwable> E filterUntil(E exception, Predicate<StackTraceElement> trace) {
        return StackUtils.update(exception, stack -> {
            StackTraceElement[] source = exception.getStackTrace();
            for (int i = 0; i < source.length; ++i) {
                if (!trace.test(source[i])) continue;
                StackTraceElement[] result = new StackTraceElement[source.length - i - 1];
                System.arraycopy(source, i + 1, result, 0, result.length);
                return result;
            }
            return source;
        });
    }

    public static List<StackTraceFrame> generateUserCodeStackTrace() {
        int stackCapacity = Config.get().getAppSecMaxStackTraceDepth();
        List elements = StackWalkerFactory.INSTANCE.walk(stream -> stream.filter(elem -> !elem.getClassName().startsWith("ddtrot.com.datadog") && !elem.getClassName().startsWith("ddtrot.dd.trace")).limit(stackCapacity).collect(Collectors.toList()));
        return IntStream.range(0, elements.size()).mapToObj(idx -> new StackTraceFrame(idx, (StackTraceElement)elements.get(idx))).collect(Collectors.toList());
    }

    public static void addStacktraceEventsToMetaStruct(RequestContext reqCtx, String productKey, List<StackTraceEvent> events) {
        Map stackTraceBatch = reqCtx.getOrCreateMetaStructTop(META_STRUCT_KEY, k -> new ConcurrentHashMap());
        List list = stackTraceBatch.computeIfAbsent(productKey, k -> Collections.synchronizedList(new ArrayList()));
        list.addAll(events);
    }

    private static class OneTimePredicate<T>
    implements Predicate<T> {
        private final Predicate<T> delegate;
        private boolean filtered;

        private OneTimePredicate(Predicate<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean test(T item) {
            if (this.filtered) {
                return true;
            }
            boolean test = this.delegate.test(item);
            if (!test) {
                this.filtered = true;
            }
            return test;
        }
    }
}

