/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.telemetry;

import ddtrot.dd.trace.api.civisibility.telemetry.TagValue;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.Command;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.Endpoint;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.ResponseCompressed;
import ddtrot.dd.trace.api.telemetry.MetricCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum CiVisibilityDistributionMetric {
    ENDPOINT_PAYLOAD_BYTES("endpoint_payload.bytes", Endpoint.class),
    ENDPOINT_PAYLOAD_REQUESTS_MS("endpoint_payload.requests_ms", Endpoint.class),
    ENDPOINT_PAYLOAD_EVENTS_COUNT("endpoint_payload.events_count", Endpoint.class),
    ENDPOINT_PAYLOAD_EVENTS_SERIALIZATION_MS("endpoint_payload.events_serialization_ms", Endpoint.class),
    GIT_COMMAND_MS("git.command_ms", Command.class),
    GIT_REQUESTS_SEARCH_COMMITS_MS("git_requests.search_commits_ms", new Class[0]),
    GIT_REQUESTS_OBJECTS_PACK_MS("git_requests.objects_pack_ms", new Class[0]),
    GIT_REQUESTS_OBJECTS_PACK_BYTES("git_requests.objects_pack_bytes", new Class[0]),
    GIT_REQUESTS_OBJECTS_PACK_FILES("git_requests.objects_pack_files", new Class[0]),
    GIT_REQUESTS_SETTINGS_MS("git_requests.settings_ms", new Class[0]),
    ITR_SKIPPABLE_TESTS_REQUEST_MS("itr_skippable_tests.request_ms", new Class[0]),
    ITR_SKIPPABLE_TESTS_RESPONSE_BYTES("itr_skippable_tests.response_bytes", ResponseCompressed.class),
    CODE_COVERAGE_FILES("code_coverage.files", new Class[0]),
    EFD_REQUEST_MS("early_flake_detection.request_ms", new Class[0]),
    EFD_RESPONSE_BYTES("early_flake_detection.response_bytes", ResponseCompressed.class),
    EFD_RESPONSE_TESTS("early_flake_detection.response_tests", new Class[0]),
    FLAKY_TESTS_REQUEST_MS("flaky_tests.request_ms", new Class[0]),
    FLAKY_TESTS_RESPONSE_BYTES("flaky_tests.response_bytes", ResponseCompressed.class),
    FLAKY_TESTS_RESPONSE_TESTS("flaky_tests.response_tests", new Class[0]);

    private static final String NAMESPACE = "civisibility";
    private final String name;
    private final Class<? extends TagValue>[] tags;

    @SafeVarargs
    private CiVisibilityDistributionMetric(String metricName, Class<? extends TagValue> ... metricTags) {
        this.name = metricName;
        this.tags = metricTags;
    }

    public String getName() {
        return this.name;
    }

    public MetricCollector.DistributionSeriesPoint createDataPoint(int value, TagValue ... tagValues) {
        List<String> tags;
        if (tagValues.length != 0) {
            tags = new ArrayList(tagValues.length);
            for (TagValue tagValue : tagValues) {
                if (tagValue == null) continue;
                this.assertValid(tagValue);
                tags.add(tagValue.asString());
            }
        } else {
            tags = Collections.emptyList();
        }
        return new MetricCollector.DistributionSeriesPoint(this.name, true, NAMESPACE, value, tags);
    }

    private void assertValid(TagValue tagValue) {
        Class<? extends TagValue> tag = tagValue.getDeclaringClass();
        for (Class<? extends TagValue> aClass : this.tags) {
            if (tag != aClass) continue;
            return;
        }
        throw new IllegalArgumentException("Metric " + this.name() + " cannot be tagged with " + tag.getSimpleName() + ", allowed tags are " + Arrays.toString(this.tags));
    }
}

