/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.naming;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.env.CapturedEnvironment;
import ddtrot.dd.trace.api.remoteconfig.ServiceNameCollector;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClassloaderServiceNames {
    private static final boolean ENABLED = Config.get().isJeeSplitByDeployment() && !Config.get().isServiceNameSetByUser();
    private final WeakHashMap<ClassLoader, String> weakCache = new WeakHashMap();
    private final String inferredServiceName = CapturedEnvironment.get().getProperties().get("service.name");

    private ClassloaderServiceNames() {
    }

    public static void addServiceName(@Nonnull ClassLoader classLoader, @Nonnull String serviceName) {
        if (ENABLED) {
            Lazy.INSTANCE.weakCache.put(classLoader, serviceName);
        }
    }

    @Nullable
    public static String maybeGet(@Nonnull ClassLoader classLoader) {
        if (ENABLED) {
            return Lazy.INSTANCE.weakCache.get(classLoader);
        }
        return null;
    }

    @Nullable
    public static String maybeGetForCurrentThread() {
        return ClassloaderServiceNames.maybeGet(Thread.currentThread().getContextClassLoader());
    }

    public static void maybeSetToSpan(@Nonnull AgentSpan span) {
        ClassloaderServiceNames.maybeSetToSpan(span, Thread.currentThread().getContextClassLoader());
    }

    public static void maybeSetToSpan(@Nonnull AgentSpan span, @Nonnull ClassLoader classLoader) {
        if (!ENABLED) {
            return;
        }
        String currentServiceName = span.getServiceName();
        if (currentServiceName != null && !currentServiceName.equals(Lazy.INSTANCE.inferredServiceName)) {
            return;
        }
        String service = ClassloaderServiceNames.maybeGet(classLoader);
        if (service != null) {
            span.setServiceName(service);
            ServiceNameCollector.get().addService(service);
        }
    }

    private static class Lazy {
        private static final ClassloaderServiceNames INSTANCE = new ClassloaderServiceNames();

        private Lazy() {
        }
    }
}

