/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.remoteconfig;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.telemetry.LogCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNameCollector {
    private static final Logger log = LoggerFactory.getLogger(ServiceNameCollector.class);
    private static final int MAX_EXTRA_SERVICE = Config.get().getRemoteConfigMaxExtraServices();
    private static ServiceNameCollector INSTANCE = new ServiceNameCollector();
    private final ConcurrentHashMap<String, String> services = new ConcurrentHashMap(MAX_EXTRA_SERVICE);
    volatile boolean limitReachedLogged = false;

    public static ServiceNameCollector get() {
        return INSTANCE;
    }

    ServiceNameCollector() {
    }

    public void addService(String serviceName) {
        if (serviceName == null || serviceName.isEmpty()) {
            return;
        }
        if (this.services.size() >= MAX_EXTRA_SERVICE) {
            if (!this.limitReachedLogged) {
                log.debug(LogCollector.SEND_TELEMETRY, "extra service limit({}) reached: service {} can't be added", (Object)MAX_EXTRA_SERVICE, (Object)serviceName);
                this.limitReachedLogged = true;
            }
            return;
        }
        if (!Config.get().getServiceName().equalsIgnoreCase(serviceName)) {
            this.services.put(serviceName.toLowerCase(Locale.ROOT), serviceName);
        }
    }

    @Nullable
    public List<String> getServices() {
        return this.services.isEmpty() ? null : new ArrayList<String>(this.services.values());
    }

    public void clear() {
        this.services.clear();
    }
}

