/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.DDTraceId;
import datadog.trace.api.internal.TraceSegment;
import datadog.trace.api.sampling.SamplingMechanism;
import ddtrot.dd.trace.api.Functions;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.api.cache.RadixTreeCache;
import ddtrot.dd.trace.api.gateway.BlockResponseFunction;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.bootstrap.instrumentation.api.PathwayContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilerContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import ddtrot.dd.trace.core.CoreTracer;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.DDSpanLink;
import ddtrot.dd.trace.core.Metadata;
import ddtrot.dd.trace.core.MetadataConsumer;
import ddtrot.dd.trace.core.TraceCollector;
import ddtrot.dd.trace.core.propagation.PropagationTags;
import ddtrot.dd.trace.core.taginterceptor.TagInterceptor;
import ddtrot.dd.trace.core.tagprocessor.TagsPostProcessorFactory;
import ddtrot.dd.trace.util.TagsHelper;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpanContext
implements AgentSpan.Context,
RequestContext,
TraceSegment,
ProfilerContext {
    private static final Logger log = LoggerFactory.getLogger(DDSpanContext.class);
    public static final String PRIORITY_SAMPLING_KEY = "_sampling_priority_v1";
    public static final String SAMPLE_RATE_KEY = "_sample_rate";
    public static final String SPAN_SAMPLING_MECHANISM_TAG = "_dd.span_sampling.mechanism";
    public static final String SPAN_SAMPLING_RULE_RATE_TAG = "_dd.span_sampling.rule_rate";
    public static final String SPAN_SAMPLING_MAX_PER_SECOND_TAG = "_dd.span_sampling.max_per_second";
    private static final DDCache<String, UTF8BytesString> THREAD_NAMES = DDCaches.newFixedSizeCache(256);
    private static final Map<String, String> EMPTY_BAGGAGE = Collections.emptyMap();
    private static final Map<String, Object> EMPTY_META_STRUCT = Collections.emptyMap();
    private final TraceCollector traceCollector;
    private volatile Map<String, String> baggageItems;
    private final DDTraceId traceId;
    private final long spanId;
    private final long parentId;
    private final String parentServiceName;
    private final long threadId;
    private final UTF8BytesString threadName;
    private volatile short httpStatusCode;
    private final Map<String, Object> unsafeTags;
    private volatile String serviceName;
    private volatile CharSequence resourceName;
    private volatile byte resourceNamePriority = 0;
    private volatile CharSequence operationName;
    private volatile CharSequence spanType;
    private volatile boolean errorFlag;
    private volatile byte errorFlagPriority = (byte)-128;
    private volatile boolean measured;
    private volatile boolean topLevel;
    private static final AtomicIntegerFieldUpdater<DDSpanContext> SAMPLING_PRIORITY_UPDATER = AtomicIntegerFieldUpdater.newUpdater(DDSpanContext.class, "samplingPriority");
    private volatile int samplingPriority = -128;
    private volatile CharSequence origin;
    private final Object requestContextDataAppSec;
    private final Object requestContextDataIast;
    private final Object ciVisibilityContextData;
    private final boolean disableSamplingMechanismValidation;
    private final PropagationTags propagationTags;
    private volatile PathwayContext pathwayContext;
    private volatile BlockResponseFunction blockResponseFunction;
    private final ProfilingContextIntegration profilingContextIntegration;
    private final boolean injectBaggageAsTags;
    private volatile int encodedOperationName;
    private volatile int encodedResourceName;
    private volatile boolean requiresPostProcessing;
    private volatile CharSequence lastParentId;
    private final boolean isRemote;
    private volatile Map<String, Object> metaStruct = EMPTY_META_STRUCT;

    public DDSpanContext(DDTraceId traceId, long spanId, long parentId, CharSequence parentServiceName, String serviceName, CharSequence operationName, CharSequence resourceName, int samplingPriority, CharSequence origin, Map<String, String> baggageItems, boolean errorFlag, CharSequence spanType, int tagsSize, TraceCollector traceCollector, Object requestContextDataAppSec, Object requestContextDataIast, PathwayContext pathwayContext, boolean disableSamplingMechanismValidation, PropagationTags propagationTags) {
        this(traceId, spanId, parentId, parentServiceName, serviceName, operationName, resourceName, samplingPriority, origin, baggageItems, errorFlag, spanType, tagsSize, traceCollector, requestContextDataAppSec, requestContextDataIast, null, pathwayContext, disableSamplingMechanismValidation, propagationTags, ProfilingContextIntegration.NoOp.INSTANCE, true, false);
    }

    public DDSpanContext(DDTraceId traceId, long spanId, long parentId, CharSequence parentServiceName, String serviceName, CharSequence operationName, CharSequence resourceName, int samplingPriority, CharSequence origin, Map<String, String> baggageItems, boolean errorFlag, CharSequence spanType, int tagsSize, TraceCollector traceCollector, Object requestContextDataAppSec, Object requestContextDataIast, PathwayContext pathwayContext, boolean disableSamplingMechanismValidation, PropagationTags propagationTags, boolean injectBaggageAsTags) {
        this(traceId, spanId, parentId, parentServiceName, serviceName, operationName, resourceName, samplingPriority, origin, baggageItems, errorFlag, spanType, tagsSize, traceCollector, requestContextDataAppSec, requestContextDataIast, null, pathwayContext, disableSamplingMechanismValidation, propagationTags, ProfilingContextIntegration.NoOp.INSTANCE, injectBaggageAsTags, false);
    }

    public DDSpanContext(DDTraceId traceId, long spanId, long parentId, CharSequence parentServiceName, String serviceName, CharSequence operationName, CharSequence resourceName, int samplingPriority, CharSequence origin, Map<String, String> baggageItems, boolean errorFlag, CharSequence spanType, int tagsSize, TraceCollector traceCollector, Object requestContextDataAppSec, Object requestContextDataIast, PathwayContext pathwayContext, boolean disableSamplingMechanismValidation, PropagationTags propagationTags, ProfilingContextIntegration profilingContextIntegration) {
        this(traceId, spanId, parentId, parentServiceName, serviceName, operationName, resourceName, samplingPriority, origin, baggageItems, errorFlag, spanType, tagsSize, traceCollector, requestContextDataAppSec, requestContextDataIast, null, pathwayContext, disableSamplingMechanismValidation, propagationTags, profilingContextIntegration, true, false);
    }

    public DDSpanContext(DDTraceId traceId, long spanId, long parentId, CharSequence parentServiceName, String serviceName, CharSequence operationName, CharSequence resourceName, int samplingPriority, CharSequence origin, Map<String, String> baggageItems, boolean errorFlag, CharSequence spanType, int tagsSize, TraceCollector traceCollector, Object requestContextDataAppSec, Object requestContextDataIast, Object CiVisibilityContextData, PathwayContext pathwayContext, boolean disableSamplingMechanismValidation, PropagationTags propagationTags, ProfilingContextIntegration profilingContextIntegration, boolean injectBaggageAsTags, boolean isRemote) {
        assert (traceCollector != null);
        this.traceCollector = traceCollector;
        assert (traceId != null);
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.parentServiceName = String.valueOf(parentServiceName);
        this.baggageItems = baggageItems == null || baggageItems.isEmpty() ? EMPTY_BAGGAGE : new ConcurrentHashMap<String, String>(baggageItems);
        this.requestContextDataAppSec = requestContextDataAppSec;
        this.requestContextDataIast = requestContextDataIast;
        this.ciVisibilityContextData = CiVisibilityContextData;
        assert (pathwayContext != null);
        this.pathwayContext = pathwayContext;
        int capacity = Math.max((tagsSize <= 0 ? 3 : tagsSize + 1) * 4 / 3, 8);
        this.unsafeTags = new HashMap<String, Object>(capacity);
        this.profilingContextIntegration = profilingContextIntegration;
        this.encodedOperationName = profilingContextIntegration.encodeOperationName(operationName);
        this.setServiceName(serviceName);
        this.operationName = operationName;
        this.setResourceName(resourceName, (byte)0);
        this.errorFlag = errorFlag;
        this.spanType = spanType;
        Thread current = Thread.currentThread();
        this.threadId = current.getId();
        this.threadName = THREAD_NAMES.computeIfAbsent(current.getName(), Functions.UTF8_ENCODE);
        this.disableSamplingMechanismValidation = disableSamplingMechanismValidation;
        this.propagationTags = propagationTags != null ? propagationTags : traceCollector.getTracer().getPropagationTagsFactory().empty();
        this.propagationTags.updateTraceIdHighOrderBits(this.traceId.toHighOrderLong());
        this.injectBaggageAsTags = injectBaggageAsTags;
        if (origin != null) {
            this.setOrigin(origin);
        }
        if (samplingPriority != -128) {
            this.setSamplingPriority(samplingPriority, -1);
        }
        this.setLastParentId(this.propagationTags.getLastParentId());
        this.isRemote = isRemote;
    }

    @Override
    public DDTraceId getTraceId() {
        return this.traceId;
    }

    public long getParentId() {
        return this.parentId;
    }

    @Override
    public long getSpanId() {
        return this.spanId;
    }

    @Override
    public long getRootSpanId() {
        return this.getRootSpanContextOrThis().spanId;
    }

    @Override
    public int getEncodedOperationName() {
        return this.encodedOperationName;
    }

    @Override
    public int getEncodedResourceName() {
        return this.encodedResourceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = this.traceCollector.mapServiceName(serviceName);
        this.topLevel = DDSpanContext.isTopLevel(this.parentServiceName, this.serviceName);
    }

    @Override
    public CharSequence getResourceName() {
        return this.isResourceNameSet() ? this.resourceName : this.operationName;
    }

    public boolean hasResourceName() {
        return this.isResourceNameSet() || this.getTag("resource.name") != null;
    }

    public byte getResourceNamePriority() {
        return this.resourceNamePriority;
    }

    public void setResourceName(CharSequence resourceName, byte priority) {
        if (null == resourceName) {
            return;
        }
        if (priority >= this.resourceNamePriority) {
            this.resourceNamePriority = priority;
            this.resourceName = resourceName;
            this.encodedResourceName = this.profilingContextIntegration.encodeResourceName(resourceName);
        }
    }

    private boolean isResourceNameSet() {
        return this.resourceName != null && this.resourceName.length() != 0;
    }

    @Override
    public CharSequence getOperationName() {
        return this.operationName;
    }

    public void setOperationName(CharSequence operationName) {
        this.operationName = operationName;
        this.encodedOperationName = this.profilingContextIntegration.encodeOperationName(operationName);
    }

    public boolean getErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean errorFlag, byte priority) {
        if (priority > -128 && priority >= this.errorFlagPriority) {
            this.errorFlag = errorFlag;
            this.errorFlagPriority = priority;
        }
    }

    public boolean isMeasured() {
        return this.measured;
    }

    public void setMeasured(boolean measured) {
        if (measured != this.measured) {
            this.measured = measured;
        }
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    private static boolean isTopLevel(String parentServiceName, String serviceName) {
        return parentServiceName == null || parentServiceName.length() == 0 || !parentServiceName.equals(serviceName);
    }

    public CharSequence getSpanType() {
        return this.spanType;
    }

    public void setSpanType(CharSequence spanType) {
        this.spanType = spanType;
    }

    public void forceKeep() {
        this.forceKeep((byte)4);
    }

    public void forceKeep(byte samplingMechanism) {
        this.getRootSpanContextOrThis().forceKeepThisSpan(samplingMechanism);
    }

    private void forceKeepThisSpan(byte samplingMechanism) {
        if (SAMPLING_PRIORITY_UPDATER.getAndSet(this, 2) == -128) {
            this.propagationTags.updateTraceSamplingPriority(2, samplingMechanism);
        }
    }

    public void updateAppsecPropagation(boolean value) {
        this.propagationTags.updateAppsecPropagation(value);
    }

    public void updateDebugPropagation(String value) {
        this.propagationTags.updateDebugPropagation(value);
    }

    public boolean setSamplingPriority(int newPriority, int newMechanism) {
        DDSpanContext spanContext = this.getRootSpanContextOrThis();
        return spanContext.setThisSpanSamplingPriority(newPriority, newMechanism);
    }

    private DDSpanContext getRootSpanContextOrThis() {
        DDSpanContext rootSpanContext = this.getRootSpanContextIfDifferent();
        return rootSpanContext != null ? rootSpanContext : this;
    }

    private DDSpanContext getRootSpanContextIfDifferent() {
        DDSpan rootSpan;
        if (this.traceCollector != null && null != (rootSpan = this.traceCollector.getRootSpan()) && rootSpan.context() != this) {
            return rootSpan.context();
        }
        return null;
    }

    private boolean setThisSpanSamplingPriority(int newPriority, int newMechanism) {
        if (!this.validateSamplingPriority(newPriority, newMechanism)) {
            return false;
        }
        if (SamplingMechanism.canAvoidSamplingPriorityLock(newPriority, newMechanism)) {
            SAMPLING_PRIORITY_UPDATER.set(this, newPriority);
            this.propagationTags.updateTraceSamplingPriority(newPriority, newMechanism);
            return true;
        }
        if (!SAMPLING_PRIORITY_UPDATER.compareAndSet(this, -128, newPriority)) {
            if (log.isDebugEnabled()) {
                log.debug("samplingPriority locked at priority: {}. Refusing to set to priority: {} mechanism: {}", new Object[]{this.samplingPriority, newPriority, newMechanism});
            }
            return false;
        }
        this.propagationTags.updateTraceSamplingPriority(newPriority, newMechanism);
        return true;
    }

    private boolean validateSamplingPriority(int newPriority, int newMechanism) {
        if (newPriority == -128) {
            log.debug("{}: Refusing to set samplingPriority to UNSET", (Object)this);
            return false;
        }
        if (!SamplingMechanism.validateWithSamplingPriority(newMechanism, newPriority)) {
            if (this.disableSamplingMechanismValidation) {
                log.debug("{}: Bypassing setting setSamplingPriority check (trace.sampling.mechanism.validation.disabled) for a non valid combination of samplingMechanism {} and samplingPriority {}.", new Object[]{this, newMechanism, newPriority});
            } else {
                log.debug("{}: Refusing to set samplingMechanism to {}. Provided samplingPriority {} is not allowed.", new Object[]{this, newMechanism, newPriority});
                return false;
            }
        }
        return true;
    }

    @Override
    public int getSamplingPriority() {
        return this.getRootSpanContextOrThis().samplingPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpanSamplingPriority(double rate, int limit) {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            this.unsafeSetTag(SPAN_SAMPLING_MECHANISM_TAG, (byte)8);
            this.unsafeSetTag(SPAN_SAMPLING_RULE_RATE_TAG, rate);
            if (limit != Integer.MAX_VALUE) {
                this.unsafeSetTag(SPAN_SAMPLING_MAX_PER_SECOND_TAG, limit);
            }
        }
    }

    @Deprecated
    public boolean lockSamplingPriority() {
        DDSpan rootSpan = this.traceCollector.getRootSpan();
        if (null != rootSpan && rootSpan.context() != this) {
            return rootSpan.context().lockSamplingPriority();
        }
        return SAMPLING_PRIORITY_UPDATER.get(this) != -128;
    }

    public CharSequence getOrigin() {
        return this.getRootSpanContextOrThis().origin;
    }

    public void beginEndToEnd() {
        this.traceCollector.beginEndToEnd();
    }

    public long getEndToEndStartTime() {
        return this.traceCollector.getEndToEndStartTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaggageItem(String key, String value) {
        if (key == null || value == null) {
            log.debug("Try to set invalid baggage: key = {}, value = {}", (Object)key, (Object)value);
            return;
        }
        if (this.baggageItems == EMPTY_BAGGAGE) {
            DDSpanContext dDSpanContext = this;
            synchronized (dDSpanContext) {
                if (this.baggageItems == EMPTY_BAGGAGE) {
                    this.baggageItems = new ConcurrentHashMap<String, String>(4);
                }
            }
        }
        this.baggageItems.put(key, value);
    }

    public String getBaggageItem(String key) {
        return this.baggageItems.get(key);
    }

    public Map<String, String> getBaggageItems() {
        return this.baggageItems;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggageItems.entrySet();
    }

    @Override
    public TraceCollector getTraceCollector() {
        return this.traceCollector;
    }

    public RequestContext getRequestContext() {
        return this;
    }

    @Override
    public PathwayContext getPathwayContext() {
        return this.pathwayContext;
    }

    @Override
    public void mergePathwayContext(PathwayContext pathwayContext) {
        if (pathwayContext == null) {
            return;
        }
        if (this.pathwayContext.isStarted()) {
            if (ThreadLocalRandom.current().nextInt(2) == 1) {
                this.pathwayContext = pathwayContext;
            }
        } else {
            this.pathwayContext = pathwayContext;
        }
    }

    public CoreTracer getTracer() {
        return this.traceCollector.getTracer();
    }

    public void setHttpStatusCode(short statusCode) {
        this.httpStatusCode = statusCode;
    }

    public short getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setOrigin(CharSequence origin) {
        DDSpanContext context = this.getRootSpanContextOrThis();
        context.origin = origin;
        context.propagationTags.updateTraceOrigin(origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetric(CharSequence key, Number value) {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            this.unsafeSetTag(key.toString(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTag(String tag, Object value) {
        if (null == tag) {
            return;
        }
        if (null == value) {
            Map<String, Object> map = this.unsafeTags;
            synchronized (map) {
                this.unsafeTags.remove(tag);
            }
        }
        if (!this.traceCollector.getTracer().getTagInterceptor().interceptTag(this, tag, value)) {
            Map<String, Object> map = this.unsafeTags;
            synchronized (map) {
                this.unsafeSetTag(tag, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAllTags(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        TagInterceptor tagInterceptor = this.traceCollector.getTracer().getTagInterceptor();
        Map<String, Object> map2 = this.unsafeTags;
        synchronized (map2) {
            for (Map.Entry<String, ?> tag : map.entrySet()) {
                if (tagInterceptor.interceptTag(this, tag.getKey(), tag.getValue())) continue;
                this.unsafeSetTag(tag.getKey(), tag.getValue());
            }
        }
    }

    void unsafeSetTag(String tag, Object value) {
        this.unsafeTags.put(tag, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getTag(String key) {
        Object value;
        switch (key) {
            case "thread.id": {
                return this.threadId;
            }
            case "thread.name": {
                return this.threadName.toString();
            }
            case "http.status_code": {
                return 0 == this.httpStatusCode ? null : Integer.valueOf(this.httpStatusCode);
            }
        }
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            value = this.unsafeGetTag(key);
        }
        return value == null ? null : ("http.url".equals(key) ? value.toString() : value);
    }

    public Object unsafeGetTag(String tag) {
        return this.unsafeTags.get(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTags() {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            Object value;
            HashMap<String, Object> tags = new HashMap<String, Object>(this.unsafeTags);
            tags.put("thread.id", this.threadId);
            tags.put("thread.name", this.threadName.toString());
            if (this.samplingPriority != -128) {
                tags.put(SAMPLE_RATE_KEY, this.samplingPriority);
            }
            if (this.httpStatusCode != 0) {
                tags.put("http.status_code", this.httpStatusCode);
            }
            if ((value = tags.get("http.url")) != null) {
                tags.put("http.url", value.toString());
            }
            return Collections.unmodifiableMap(tags);
        }
    }

    public Map<String, Object> getMetaStruct() {
        return Collections.unmodifiableMap(this.metaStruct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setMetaStruct(String field, T value) {
        if (null == field) {
            return;
        }
        if (this.metaStruct == EMPTY_META_STRUCT) {
            DDSpanContext dDSpanContext = this;
            synchronized (dDSpanContext) {
                if (this.metaStruct == EMPTY_META_STRUCT) {
                    this.metaStruct = new ConcurrentHashMap<String, Object>(4);
                }
            }
        }
        if (null == value) {
            this.metaStruct.remove(field);
        } else {
            this.metaStruct.put(field, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTagsAndBaggage(MetadataConsumer consumer, int longRunningVersion, List<AgentSpanLink> links) {
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            HashMap<String, String> baggageItemsWithPropagationTags;
            Map<String, Object> tags = TagsPostProcessorFactory.instance().processTags(this.unsafeTags, this);
            String linksTag = DDSpanLink.toTag(links);
            if (linksTag != null) {
                tags.put("_dd.span_links", linksTag);
            }
            if (this.injectBaggageAsTags) {
                baggageItemsWithPropagationTags = new HashMap<String, String>(this.baggageItems);
                this.propagationTags.fillTagMap(baggageItemsWithPropagationTags);
            } else {
                baggageItemsWithPropagationTags = this.propagationTags.createTagMap();
            }
            consumer.accept(new Metadata(this.threadId, this.threadName, tags, baggageItemsWithPropagationTags, this.samplingPriority != -128 ? this.samplingPriority : this.getSamplingPriority(), this.measured, this.topLevel, this.httpStatusCode == 0 ? null : RadixTreeCache.HTTP_STATUSES.get(this.httpStatusCode), this.getOrigin(), longRunningVersion));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder s = new StringBuilder().append("DDSpan [ t_id=").append(this.traceId).append(", s_id=").append(this.spanId).append(", p_id=").append(this.parentId).append(" ] trace=").append(this.getServiceName()).append('/').append(this.getOperationName()).append('/').append(this.getResourceName());
        if (this.errorFlag) {
            s.append(" *errored*");
        }
        if (this.measured) {
            s.append(" *measured*");
        }
        Map<String, Object> map = this.unsafeTags;
        synchronized (map) {
            s.append(" tags=").append(new TreeMap<String, Object>(this.getTags()));
        }
        return s.toString();
    }

    public Object getData(RequestContextSlot slot) {
        if (slot == RequestContextSlot.APPSEC) {
            return this.requestContextDataAppSec;
        }
        if (slot == RequestContextSlot.CI_VISIBILITY) {
            return this.ciVisibilityContextData;
        }
        if (slot == RequestContextSlot.IAST) {
            return this.requestContextDataIast;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        Exception exc = null;
        if (this.requestContextDataAppSec instanceof Closeable) {
            try {
                ((Closeable)this.requestContextDataAppSec).close();
            }
            catch (IOException | RuntimeException e) {
                exc = e;
            }
        }
        if (this.requestContextDataIast instanceof Closeable) {
            try {
                ((Closeable)this.requestContextDataIast).close();
            }
            catch (IOException | RuntimeException e) {
                exc = e;
            }
        }
        if (exc != null) {
            if (exc instanceof RuntimeException) {
                throw (RuntimeException)exc;
            }
            throw (IOException)exc;
        }
    }

    @Override
    public TraceSegment getTraceSegment() {
        return this;
    }

    @Override
    public void setBlockResponseFunction(BlockResponseFunction blockResponseFunction) {
        this.getRootSpanContextOrThis().blockResponseFunction = blockResponseFunction;
    }

    @Override
    public BlockResponseFunction getBlockResponseFunction() {
        return this.getRootSpanContextOrThis().blockResponseFunction;
    }

    public PropagationTags getPropagationTags() {
        return this.getRootSpanContextOrThis().propagationTags;
    }

    public void setTagTop(String key, Object value, boolean sanitize) {
        this.getRootSpanContextOrThis().setTagCurrent(key, value, sanitize);
    }

    public Object getTagTop(String key, boolean sanitize) {
        return this.getRootSpanContextOrThis().getTagCurrent(key, sanitize);
    }

    public void setTagCurrent(String key, Object value, boolean sanitize) {
        if (sanitize) {
            key = TagsHelper.sanitize(key);
        }
        this.setTag(key, value);
    }

    public Object getTagCurrent(String key, boolean sanitize) {
        if (sanitize) {
            key = TagsHelper.sanitize(key);
        }
        return this.getTag(key);
    }

    public void setDataTop(String key, Object value) {
        this.getRootSpanContextOrThis().setDataCurrent(key, value);
    }

    public Object getDataTop(String key) {
        return this.getRootSpanContextOrThis().getDataCurrent(key);
    }

    public void effectivelyBlocked() {
        this.setTagTop("appsec.blocked", "true");
    }

    public void setDataCurrent(String key, Object value) {
        this.setTag(this.getTagName(key), value);
    }

    public Object getDataCurrent(String key) {
        return this.getTag(this.getTagName(key));
    }

    private String getTagName(String key) {
        return "_dd." + key + ".json";
    }

    public void setMetaStructTop(String field, Object value) {
        this.getRootSpanContextOrThis().setMetaStructCurrent(field, value);
    }

    @Override
    public <T> T getOrCreateMetaStructTop(String key, Function<String, T> defaultValue) {
        DDSpanContext top = this.getRootSpanContextOrThis();
        if (top.metaStruct == EMPTY_META_STRUCT) {
            top.setMetaStruct(key, defaultValue.apply(key));
        }
        return (T)top.metaStruct.computeIfAbsent(key, defaultValue);
    }

    public void setMetaStructCurrent(String field, Object value) {
        this.setMetaStruct(field, value);
    }

    public void setRequiresPostProcessing(boolean postProcessing) {
        this.requiresPostProcessing = postProcessing;
    }

    public boolean isRequiresPostProcessing() {
        return this.requiresPostProcessing;
    }

    public CharSequence getLastParentId() {
        return this.lastParentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastParentId(CharSequence lastParentId) {
        if (lastParentId != null) {
            Map<String, Object> map = this.unsafeTags;
            synchronized (map) {
                this.unsafeSetTag("_dd.parent_id", lastParentId);
            }
            this.lastParentId = lastParentId;
        }
    }

    public boolean isRemote() {
        return this.isRemote;
    }
}

