/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.Config;
import datadog.trace.api.DDTraceId;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTraceCollector;
import ddtrot.dd.trace.common.sampling.PrioritySampler;
import ddtrot.dd.trace.core.CoreTracer;
import ddtrot.dd.trace.core.DDSpan;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.annotation.Nonnull;

public abstract class TraceCollector
implements AgentTraceCollector {
    protected final CoreTracer tracer;
    protected final CoreTracer.ConfigSnapshot traceConfig;
    protected final TimeSource timeSource;
    private volatile long endToEndStartTime;
    private static final AtomicLongFieldUpdater<TraceCollector> END_TO_END_START_TIME = AtomicLongFieldUpdater.newUpdater(TraceCollector.class, "endToEndStartTime");

    protected TraceCollector(CoreTracer tracer, CoreTracer.ConfigSnapshot traceConfig, TimeSource timeSource) {
        this.tracer = tracer;
        this.traceConfig = traceConfig;
        this.timeSource = timeSource;
    }

    CoreTracer getTracer() {
        return this.tracer;
    }

    CoreTracer.ConfigSnapshot getTraceConfig() {
        return this.traceConfig;
    }

    String mapServiceName(String serviceName) {
        return this.traceConfig.getServiceMapping().getOrDefault(serviceName, serviceName);
    }

    boolean sample(DDSpan spanToSample) {
        return this.traceConfig.sampler.sample(spanToSample);
    }

    public void setSamplingPriorityIfNecessary() {
        DDSpan rootSpan = this.getRootSpan();
        if (this.traceConfig.sampler instanceof PrioritySampler && rootSpan != null && (Config.get().isAppSecStandaloneEnabled() && !rootSpan.context().getPropagationTags().isAppsecPropagationEnabled() || rootSpan.context().getSamplingPriority() == -128)) {
            ((PrioritySampler)((Object)this.traceConfig.sampler)).setSamplingPriority(rootSpan);
        }
    }

    public TimeSource getTimeSource() {
        return this.timeSource;
    }

    public long getCurrentTimeNano() {
        long nanoTicks = this.timeSource.getNanoTicks();
        return this.tracer.getTimeWithNanoTicks(nanoTicks);
    }

    void beginEndToEnd() {
        this.beginEndToEnd(this.getCurrentTimeNano());
    }

    void beginEndToEnd(long endToEndStartTime) {
        END_TO_END_START_TIME.compareAndSet(this, 0L, endToEndStartTime);
    }

    long getEndToEndStartTime() {
        return this.endToEndStartTime;
    }

    abstract void touch();

    abstract void registerSpan(DDSpan var1);

    abstract DDSpan getRootSpan();

    abstract PublishState onPublish(DDSpan var1);

    static enum PublishState {
        WRITTEN,
        PARTIAL_FLUSH,
        ROOT_BUFFERED,
        BUFFERED,
        PENDING;

    }

    static interface Factory {
        public TraceCollector create(@Nonnull DDTraceId var1);

        public TraceCollector create(@Nonnull DDTraceId var1, CoreTracer.ConfigSnapshot var2);
    }
}

