/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.DD128bTraceId;
import datadog.trace.api.DD64bTraceId;
import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.TracePropagationStyle;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SpanAttributes;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.DDSpanLink;
import ddtrot.dd.trace.core.propagation.B3HttpCodec;
import ddtrot.dd.trace.core.propagation.DatadogHttpCodec;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import ddtrot.dd.trace.core.propagation.HaystackHttpCodec;
import ddtrot.dd.trace.core.propagation.NoneCodec;
import ddtrot.dd.trace.core.propagation.W3CHttpCodec;
import ddtrot.dd.trace.core.propagation.XRayHttpCodec;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCodec {
    private static final Logger log = LoggerFactory.getLogger(HttpCodec.class);
    static final String FORWARDED_KEY = "forwarded";
    static final String FORWARDED_FOR_KEY = "forwarded-for";
    static final String X_FORWARDED_PROTO_KEY = "x-forwarded-proto";
    static final String X_FORWARDED_HOST_KEY = "x-forwarded-host";
    static final String X_FORWARDED_FOR_KEY = "x-forwarded-for";
    static final String X_FORWARDED_PORT_KEY = "x-forwarded-port";
    static final String X_CLIENT_IP_KEY = "x-client-ip";
    static final String TRUE_CLIENT_IP_KEY = "true-client-ip";
    static final String X_CLUSTER_CLIENT_IP_KEY = "x-cluster-client-ip";
    static final String X_REAL_IP_KEY = "x-real-ip";
    static final String USER_AGENT_KEY = "user-agent";
    static final String FASTLY_CLIENT_IP_KEY = "fastly-client-ip";
    static final String CF_CONNECTING_IP_KEY = "cf-connecting-ip";
    static final String CF_CONNECTING_IP_V6_KEY = "cf-connecting-ipv6";

    public static Injector createInjector(Config config, Set<TracePropagationStyle> styles, Map<String, String> invertedBaggageMapping) {
        ArrayList<Injector> injectors = new ArrayList<Injector>(HttpCodec.createInjectors(config, styles, invertedBaggageMapping).values());
        return new CompoundInjector(injectors);
    }

    public static Map<TracePropagationStyle, Injector> allInjectorsFor(Config config, Map<String, String> reverseBaggageMapping) {
        return HttpCodec.createInjectors(config, EnumSet.allOf(TracePropagationStyle.class), reverseBaggageMapping);
    }

    private static Map<TracePropagationStyle, Injector> createInjectors(Config config, Set<TracePropagationStyle> propagationStyles, Map<String, String> reverseBaggageMapping) {
        EnumMap<TracePropagationStyle, Injector> result = new EnumMap<TracePropagationStyle, Injector>(TracePropagationStyle.class);
        block9: for (TracePropagationStyle style : propagationStyles) {
            switch (style) {
                case DATADOG: {
                    result.put(style, DatadogHttpCodec.newInjector(reverseBaggageMapping));
                    continue block9;
                }
                case B3SINGLE: {
                    result.put(style, B3HttpCodec.newSingleInjector(config.isTracePropagationStyleB3PaddingEnabled()));
                    continue block9;
                }
                case B3MULTI: {
                    result.put(style, B3HttpCodec.newMultiInjector(config.isTracePropagationStyleB3PaddingEnabled()));
                    continue block9;
                }
                case HAYSTACK: {
                    result.put(style, HaystackHttpCodec.newInjector(reverseBaggageMapping));
                    continue block9;
                }
                case XRAY: {
                    result.put(style, XRayHttpCodec.newInjector(reverseBaggageMapping));
                    continue block9;
                }
                case NONE: {
                    result.put(style, NoneCodec.INJECTOR);
                    continue block9;
                }
                case TRACECONTEXT: {
                    result.put(style, W3CHttpCodec.newInjector(reverseBaggageMapping));
                    continue block9;
                }
            }
            log.debug("No implementation found to inject propagation style: {}", (Object)style);
        }
        return result;
    }

    public static Extractor createExtractor(Config config, Supplier<TraceConfig> traceConfigSupplier) {
        ArrayList<Extractor> extractors = new ArrayList<Extractor>();
        block13: for (TracePropagationStyle style : config.getTracePropagationStylesToExtract()) {
            switch (style) {
                case DATADOG: {
                    extractors.add(DatadogHttpCodec.newExtractor(config, traceConfigSupplier));
                    continue block13;
                }
                case B3SINGLE: {
                    extractors.add(B3HttpCodec.newSingleExtractor(config, traceConfigSupplier));
                    continue block13;
                }
                case B3MULTI: {
                    extractors.add(B3HttpCodec.newMultiExtractor(config, traceConfigSupplier));
                    continue block13;
                }
                case HAYSTACK: {
                    extractors.add(HaystackHttpCodec.newExtractor(config, traceConfigSupplier));
                    continue block13;
                }
                case XRAY: {
                    extractors.add(XRayHttpCodec.newExtractor(config, traceConfigSupplier));
                    continue block13;
                }
                case NONE: {
                    extractors.add(NoneCodec.newExtractor(config, traceConfigSupplier));
                    continue block13;
                }
                case TRACECONTEXT: {
                    extractors.add(W3CHttpCodec.newExtractor(config, traceConfigSupplier));
                    continue block13;
                }
            }
            log.debug("No implementation found to extract propagation style: {}", (Object)style);
        }
        switch (extractors.size()) {
            case 0: {
                return StubExtractor.INSTANCE;
            }
            case 1: {
                return (Extractor)extractors.get(0);
            }
        }
        return new CompoundExtractor(extractors, config.isTracePropagationExtractFirst());
    }

    private static boolean traceIdMatch(DDTraceId a, DDTraceId b) {
        if (a instanceof DD128bTraceId && b instanceof DD128bTraceId || a instanceof DD64bTraceId && b instanceof DD64bTraceId) {
            return a.equals(b);
        }
        return a.toLong() == b.toLong();
    }

    static String encode(String value) {
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Failed to encode value - {}", (Object)value);
        }
        return encoded;
    }

    static String encodeBaggage(String value) {
        return HttpCodec.encode(value).replace("+", "%20");
    }

    static String decode(String value) {
        String decoded = value;
        try {
            decoded = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            log.debug("Failed to decode value - {}", (Object)value);
        }
        return decoded;
    }

    static String firstHeaderValue(String value) {
        if (value == null) {
            return null;
        }
        int firstComma = value.indexOf(44);
        return firstComma == -1 ? value : value.substring(0, firstComma).trim();
    }

    private static class ExtractionCache<C>
    implements AgentPropagation.KeyClassifier,
    AgentPropagation.ContextVisitor<ExtractionCache<?>> {
        private final List<String> keysAndValues = new ArrayList<String>(32);
        private String datadogSpanIdHex;

        public ExtractionCache(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            getter.forEachKey(carrier, this);
        }

        @Override
        public boolean accept(String key, String value) {
            this.keysAndValues.add(key);
            this.keysAndValues.add(value);
            this.cacheDatadogSpanId(key, value);
            return true;
        }

        private void cacheDatadogSpanId(String key, String value) {
            if ("x-datadog-parent-id".equalsIgnoreCase(key)) {
                try {
                    this.datadogSpanIdHex = DDSpanId.toHexStringPadded((long)DDSpanId.from((String)value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        private String getDatadogSpanIdHex() {
            return this.datadogSpanIdHex;
        }

        @Override
        public void forEachKey(ExtractionCache<?> carrier, AgentPropagation.KeyClassifier classifier) {
            List<String> keysAndValues = carrier.keysAndValues;
            for (int i = 0; i < keysAndValues.size(); i += 2) {
                classifier.accept(keysAndValues.get(i), keysAndValues.get(i + 1));
            }
        }
    }

    public static class CompoundExtractor
    implements Extractor {
        private final List<Extractor> extractors;
        private final boolean extractFirst;

        public CompoundExtractor(List<Extractor> extractors, boolean extractFirst) {
            this.extractors = extractors;
            this.extractFirst = extractFirst;
        }

        @Override
        public <C> TagContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            ExtractedContext context = null;
            TagContext partialContext = null;
            ExtractionCache<C> extractionCache = new ExtractionCache<C>(carrier, getter);
            for (Extractor extractor : this.extractors) {
                TagContext extracted = extractor.extract(extractionCache, extractionCache);
                if (extracted instanceof ExtractedContext) {
                    ExtractedContext extractedContext = (ExtractedContext)extracted;
                    if (context == null) {
                        context = extractedContext;
                        if (!this.extractFirst) continue;
                        break;
                    }
                    if (HttpCodec.traceIdMatch(context.getTraceId(), extractedContext.getTraceId())) {
                        boolean comingFromTraceContext = extracted.getPropagationStyle() == TracePropagationStyle.TRACECONTEXT;
                        if (!comingFromTraceContext) continue;
                        this.applyTraceContextToFirstContext(context, extractedContext, extractionCache);
                        continue;
                    }
                    context.addTerminatedContextLink(DDSpanLink.from((ExtractedContext)extracted, SpanAttributes.builder().put("reason", "terminated_context").put("context_headers", extracted.getPropagationStyle().toString()).build()));
                    continue;
                }
                if (extracted == null || partialContext != null) continue;
                partialContext = extracted;
            }
            if (context != null) {
                log.debug("Extract complete context {}", context);
                return context;
            }
            if (partialContext != null) {
                log.debug("Extract incomplete context {}", partialContext);
                return partialContext;
            }
            log.debug("Extract no context");
            return null;
        }

        private <C> void applyTraceContextToFirstContext(ExtractedContext firstContext, ExtractedContext traceContext, ExtractionCache<C> extractionCache) {
            String extractedTracestate = traceContext.getPropagationTags().getW3CTracestate();
            firstContext.getPropagationTags().updateW3CTracestate(extractedTracestate);
            if (firstContext.getSpanId() != traceContext.getSpanId()) {
                firstContext.overrideSpanId(traceContext.getSpanId());
                CharSequence lastParentId = traceContext.getPropagationTags().getLastParentId();
                if (lastParentId == null) {
                    lastParentId = ((ExtractionCache)extractionCache).getDatadogSpanIdHex();
                }
                if (lastParentId != null) {
                    firstContext.putTag("_dd.parent_id", lastParentId.toString());
                }
            }
        }
    }

    private static class StubExtractor
    implements Extractor {
        private static final StubExtractor INSTANCE = new StubExtractor();

        private StubExtractor() {
        }

        @Override
        public <C> TagContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            return null;
        }
    }

    public static class CompoundInjector
    implements Injector {
        private final List<Injector> injectors;

        public CompoundInjector(List<Injector> injectors) {
            this.injectors = injectors;
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            log.debug("Inject context {}", (Object)context);
            for (Injector injector : this.injectors) {
                injector.inject(context, carrier, setter);
            }
        }
    }

    public static interface Extractor {
        public <C> TagContext extract(C var1, AgentPropagation.ContextVisitor<C> var2);

        default public void cleanup() {
        }
    }

    public static interface Injector {
        public <C> void inject(DDSpanContext var1, C var2, AgentPropagation.Setter<C> var3);
    }
}

