/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.context;

import ddtrot.dd.context.Context;
import ddtrot.dd.context.ContextManager;
import ddtrot.dd.context.ContextScope;
import ddtrot.dd.context.EmptyContext;

final class ThreadLocalContextManager
implements ContextManager {
    private static final ThreadLocal<Context[]> CURRENT_HOLDER = ThreadLocal.withInitial(() -> new Context[]{EmptyContext.INSTANCE});

    ThreadLocalContextManager() {
    }

    @Override
    public Context root() {
        return EmptyContext.INSTANCE;
    }

    @Override
    public Context current() {
        return CURRENT_HOLDER.get()[0];
    }

    @Override
    public ContextScope attach(final Context context) {
        final Context[] holder = CURRENT_HOLDER.get();
        final Context previous = holder[0];
        holder[0] = context;
        return new ContextScope(){
            private boolean closed;

            @Override
            public Context context() {
                return context;
            }

            @Override
            public void close() {
                if (!this.closed && context == holder[0]) {
                    holder[0] = previous;
                    this.closed = true;
                }
            }
        };
    }

    @Override
    public Context swap(Context context) {
        Context[] holder = CURRENT_HOLDER.get();
        Context previous = holder[0];
        holder[0] = context;
        return previous;
    }
}

