/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.LogHandler;
import datadog.opentracing.OTScopeManager;
import datadog.opentracing.OTSpan;
import datadog.opentracing.OTSpanContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AttachableWrapper;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;

class TypeConverter {
    private final LogHandler logHandler;
    private final OTSpan noopSpanWrapper;
    private final OTSpanContext noopContextWrapper;
    private final OTScopeManager.OTScope noopScopeWrapper;

    public TypeConverter(LogHandler logHandler) {
        this.logHandler = logHandler;
        this.noopSpanWrapper = new OTSpan(AgentTracer.noopSpan(), this, logHandler);
        this.noopContextWrapper = new OTSpanContext(AgentTracer.noopSpanContext());
        this.noopScopeWrapper = new OTScopeManager.OTScope(AgentTracer.noopScope(), false, this);
    }

    public AgentSpan toAgentSpan(Span span) {
        if (span == null) {
            return null;
        }
        if (span instanceof OTSpan) {
            return ((OTSpan)span).asAgentSpan();
        }
        return AgentTracer.noopSpan();
    }

    public OTSpan toSpan(AgentSpan agentSpan) {
        if (agentSpan == null) {
            return null;
        }
        if (agentSpan instanceof AttachableWrapper) {
            AttachableWrapper attachableSpanWrapper = (AttachableWrapper)((Object)agentSpan);
            Object wrapper = attachableSpanWrapper.getWrapper();
            if (wrapper instanceof OTSpan) {
                return (OTSpan)wrapper;
            }
            OTSpan spanWrapper = new OTSpan(agentSpan, this, this.logHandler);
            attachableSpanWrapper.attachWrapper(spanWrapper);
            return spanWrapper;
        }
        if (agentSpan == AgentTracer.noopSpan()) {
            return this.noopSpanWrapper;
        }
        return new OTSpan(agentSpan, this, this.logHandler);
    }

    public Scope toScope(AgentScope scope, boolean finishSpanOnClose) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof AttachableWrapper) {
            OTScopeManager.OTScope attachedScopeWrapper;
            AttachableWrapper attachableScopeWrapper = (AttachableWrapper)((Object)scope);
            Object wrapper = attachableScopeWrapper.getWrapper();
            if (wrapper instanceof OTScopeManager.OTScope && (attachedScopeWrapper = (OTScopeManager.OTScope)wrapper).isFinishSpanOnClose() == finishSpanOnClose) {
                return (Scope)wrapper;
            }
            OTScopeManager.OTScope otScope = new OTScopeManager.OTScope(scope, finishSpanOnClose, this);
            attachableScopeWrapper.attachWrapper(otScope);
            return otScope;
        }
        if (scope == AgentTracer.noopScope()) {
            return this.noopScopeWrapper;
        }
        return new OTScopeManager.OTScope(scope, finishSpanOnClose, this);
    }

    public SpanContext toSpanContext(AgentSpanContext context) {
        if (context == null) {
            return null;
        }
        if (context == AgentTracer.noopSpanContext()) {
            return this.noopContextWrapper;
        }
        return new OTSpanContext(context);
    }

    public AgentSpanContext toContext(SpanContext spanContext) {
        if (spanContext == null) {
            return null;
        }
        if (spanContext instanceof OTSpanContext) {
            return ((OTSpanContext)spanContext).getDelegate();
        }
        return AgentTracer.noopSpanContext();
    }
}

