/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.json;

import ddtrot.dd.json.JsonWriter;
import java.util.Collection;
import java.util.Map;

public final class JsonMapper {
    private JsonMapper() {
    }

    public static String toJson(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        try (JsonWriter writer = new JsonWriter();){
            writer.value(string);
            String string2 = writer.toString();
            return string2;
        }
    }

    public static String toJson(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        try (JsonWriter writer = new JsonWriter();){
            writer.beginObject();
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                writer.name(entry.getKey());
                Object value = entry.getValue();
                if (value == null) {
                    writer.nullValue();
                    continue;
                }
                if (value instanceof String) {
                    writer.value((String)value);
                    continue;
                }
                if (value instanceof Double) {
                    writer.value((Double)value);
                    continue;
                }
                if (value instanceof Float) {
                    writer.value(((Float)value).floatValue());
                    continue;
                }
                if (value instanceof Long) {
                    writer.value((Long)value);
                    continue;
                }
                if (value instanceof Integer) {
                    writer.value((Integer)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    writer.value((Boolean)value);
                    continue;
                }
                writer.value(value.toString());
            }
            writer.endObject();
            String string = writer.toString();
            return string;
        }
    }

    public static String toJson(Collection<String> items) {
        if (items == null || items.isEmpty()) {
            return "[]";
        }
        try (JsonWriter writer = new JsonWriter();){
            writer.beginArray();
            for (String item : items) {
                writer.value(item);
            }
            writer.endArray();
            String string = writer.toString();
            return string;
        }
    }

    public static String toJson(String[] items) {
        if (items == null) {
            return "[]";
        }
        try (JsonWriter writer = new JsonWriter();){
            writer.beginArray();
            for (String item : items) {
                writer.value(item);
            }
            writer.endArray();
            String string = writer.toString();
            return string;
        }
    }
}

