/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.config.provider;

import ddtrot.dd.trace.bootstrap.config.provider.StableConfigSource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableConfigParser {
    private static final Logger log = LoggerFactory.getLogger(StableConfigParser.class);
    private static final Pattern idPattern = Pattern.compile("^config_id\\s*:(.*)$");
    private static final Pattern apmConfigPattern = Pattern.compile("^apm_configuration_default:$");
    private static final Pattern keyValPattern = Pattern.compile("^\\s{2}([^:]+):\\s*(\"[^\"]*\"|[^\"\\n]*)$");

    public static StableConfigSource.StableConfig parse(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            log.debug("Stable configuration file not available at specified path: {}", (Object)file);
            return StableConfigSource.StableConfig.EMPTY;
        }
        HashMap<String, String> configMap = new HashMap<String, String>();
        String[] configId = new String[1];
        try (Stream<String> lines = Files.lines(Paths.get(filePath, new String[0]));){
            int apmConfigNotFound = -1;
            int apmConfigStarted = 0;
            int apmConfigComplete = 1;
            int[] apmConfigFound = new int[]{apmConfigNotFound};
            lines.forEach(line -> {
                Matcher matcher = idPattern.matcher((CharSequence)line);
                if (matcher.find()) {
                    if (configId[0] != null) {
                        throw new RuntimeException("Duplicate config_id keys found; file may be malformed");
                    }
                    configId[0] = StableConfigParser.trimQuotes(matcher.group(1).trim());
                    return;
                }
                if (apmConfigFound[0] == apmConfigNotFound && apmConfigPattern.matcher((CharSequence)line).matches()) {
                    apmConfigFound[0] = apmConfigStarted;
                    return;
                }
                if (apmConfigFound[0] == apmConfigStarted) {
                    Matcher keyValueMatcher = keyValPattern.matcher((CharSequence)line);
                    if (keyValueMatcher.matches()) {
                        configMap.put(keyValueMatcher.group(1).trim(), StableConfigParser.trimQuotes(keyValueMatcher.group(2).trim()));
                    } else {
                        apmConfigFound[0] = apmConfigComplete;
                    }
                }
            });
            StableConfigSource.StableConfig stableConfig = new StableConfigSource.StableConfig(configId[0], configMap);
            return stableConfig;
        }
    }

    private static String trimQuotes(String value) {
        if (value.length() > 1 && value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

