/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.tagprocessor;

import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SpanAttributes;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SpanLink;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.tagprocessor.TagsPostProcessor;
import ddtrot.dd.trace.util.Strings;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanPointersProcessor
implements TagsPostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SpanPointersProcessor.class);
    static final String DOWN_DIRECTION = "d";
    static final String S3_PTR_KIND = "aws.s3.object";
    static final String LINK_KIND = "span-pointer";

    @Override
    public Map<String, Object> processTags(Map<String, Object> unsafeTags, DDSpanContext spanContext, List<AgentSpanLink> spanLinks) {
        String eTag = SpanPointersProcessor.asString(unsafeTags.remove("s3.eTag"));
        if (eTag == null) {
            return unsafeTags;
        }
        String bucket = SpanPointersProcessor.asString(unsafeTags.get("aws.bucket.name"));
        String key = SpanPointersProcessor.asString(unsafeTags.get("aws.object.key"));
        if (bucket == null || key == null) {
            LOG.debug("Unable to calculate span pointer hash because could not find bucket or key tags.");
            return unsafeTags;
        }
        if (!eTag.isEmpty() && eTag.charAt(0) == '\"' && eTag.charAt(eTag.length() - 1) == '\"') {
            eTag = eTag.substring(1, eTag.length() - 1);
        }
        String[] components = new String[]{bucket, key, eTag};
        try {
            SpanAttributes attributes = SpanAttributes.builder().put("ptr.kind", S3_PTR_KIND).put("ptr.dir", DOWN_DIRECTION).put("ptr.hash", SpanPointersProcessor.generatePointerHash(components)).put("link.kind", LINK_KIND).build();
            SpanLink link = SpanLink.from(AgentTracer.noopSpanContext(), (byte)0, "", attributes);
            spanLinks.add(link);
        }
        catch (Exception e) {
            LOG.debug("Failed to add span pointer: {}", (Object)e.getMessage());
        }
        return unsafeTags;
    }

    private static String asString(Object o) {
        return o == null ? null : o.toString();
    }

    private static String generatePointerHash(String[] components) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        boolean first = true;
        for (String component : components) {
            if (!first) {
                messageDigest.update((byte)124);
            } else {
                first = false;
            }
            messageDigest.update(component.getBytes(StandardCharsets.UTF_8));
        }
        byte[] fullHash = messageDigest.digest();
        byte[] truncatedHash = Arrays.copyOf(fullHash, 16);
        return Strings.toHexString(truncatedHash);
    }
}

