/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.util;

import ddtrot.dd.trace.core.util.EscapedData;
import javax.annotation.CheckForNull;

public final class PercentEscaper {
    private static final int DEST_PAD = 32;
    private static final String UNSAFE_CHARACTERS_KEY = "\",;\\()/:<=>?@[]{} ";
    private static final String UNSAFE_CHARACTERS_VALUE = "\",;\\ ";
    private static final char[] UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final boolean[] unsafeKeyOctets = PercentEscaper.createUnsafeOctets("\",;\\()/:<=>?@[]{} ");
    private static final boolean[] unsafeValOctets = PercentEscaper.createUnsafeOctets("\",;\\ ");

    public static PercentEscaper create() {
        return new PercentEscaper();
    }

    private static boolean[] createUnsafeOctets(String safeChars) {
        char[] safeCharArray;
        int maxChar = -1;
        for (char c : safeCharArray = safeChars.toCharArray()) {
            maxChar = Math.max(c, maxChar);
        }
        boolean[] octets = new boolean[maxChar + 1];
        for (char c : safeCharArray) {
            octets[c] = true;
        }
        return octets;
    }

    public EscapedData escapeKey(String s) {
        return this.escape(s, unsafeKeyOctets);
    }

    public EscapedData escapeValue(String s) {
        return this.escape(s, unsafeValOctets);
    }

    public EscapedData escape(String s, boolean[] unsafeOctets) {
        boolean size = false;
        int slen = s.length();
        for (int index = 0; index < slen; ++index) {
            char c = s.charAt(index);
            if (c <= '~' && c > ' ' && (c > unsafeOctets.length || !unsafeOctets[c])) continue;
            return PercentEscaper.escapeSlow(s, index, unsafeOctets);
        }
        return new EscapedData(s, slen);
    }

    private static EscapedData escapeSlow(String s, int index, boolean[] unsafeOctets) {
        int end = s.length();
        char[] dest = new char[1024];
        int destIndex = 0;
        int unescapedChunkStart = 0;
        EscapedData data = new EscapedData("", index);
        while (index < end) {
            int cp = PercentEscaper.codePointAt(s, index, end);
            if (cp < 0) {
                throw new IllegalArgumentException("Trailing high surrogate at end of input");
            }
            char[] escaped = PercentEscaper.escape(cp, data, unsafeOctets);
            int nextIndex = index + (Character.isSupplementaryCodePoint(cp) ? 2 : 1);
            if (escaped != null) {
                int charsSkipped = index - unescapedChunkStart;
                int sizeNeeded = destIndex + charsSkipped + escaped.length;
                if (dest.length < sizeNeeded) {
                    int destLength = sizeNeeded + (end - index) + 32;
                    dest = PercentEscaper.growBuffer(dest, destIndex, destLength);
                }
                if (charsSkipped > 0) {
                    s.getChars(unescapedChunkStart, index, dest, destIndex);
                    destIndex += charsSkipped;
                }
                if (escaped.length > 0) {
                    System.arraycopy(escaped, 0, dest, destIndex, escaped.length);
                    destIndex += escaped.length;
                }
                unescapedChunkStart = nextIndex;
            }
            index = PercentEscaper.nextEscapeIndex(s, nextIndex, end, unsafeOctets);
        }
        int charsSkipped = end - unescapedChunkStart;
        if (charsSkipped > 0) {
            int endIndex = destIndex + charsSkipped;
            if (dest.length < endIndex) {
                dest = PercentEscaper.growBuffer(dest, destIndex, endIndex);
            }
            s.getChars(unescapedChunkStart, end, dest, destIndex);
            destIndex = endIndex;
        }
        data.addSize(charsSkipped);
        data.setData(new String(dest, 0, destIndex));
        return data;
    }

    private static int nextEscapeIndex(CharSequence csq, int index, int end, boolean[] unsafeOctets) {
        char c;
        while (!(index >= end || (c = csq.charAt(index)) <= unsafeOctets.length && unsafeOctets[c])) {
            ++index;
        }
        return index;
    }

    @CheckForNull
    private static char[] escape(int cp, EscapedData data, boolean[] unsafeOctets) {
        if (cp < unsafeOctets.length && !unsafeOctets[cp]) {
            return null;
        }
        if (cp <= 127) {
            char[] dest = new char[3];
            dest[0] = 37;
            dest[2] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[1] = UPPER_HEX_DIGITS[cp >>> 4];
            data.incrementSize();
            return dest;
        }
        if (cp <= 2047) {
            char[] dest = new char[6];
            dest[0] = 37;
            dest[3] = 37;
            dest[5] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[1] = UPPER_HEX_DIGITS[0xC | (cp >>>= 4)];
            data.addSize(2);
            return dest;
        }
        if (cp <= 65535) {
            char[] dest = new char[9];
            dest[0] = 37;
            dest[1] = 69;
            dest[3] = 37;
            dest[6] = 37;
            dest[8] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[7] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[5] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[cp >>>= 2];
            data.addSize(3);
            return dest;
        }
        if (cp <= 0x10FFFF) {
            char[] dest = new char[12];
            dest[0] = 37;
            dest[1] = 70;
            dest[3] = 37;
            dest[6] = 37;
            dest[9] = 37;
            dest[11] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[10] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[8] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[7] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[5] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[(cp >>>= 2) & 7];
            data.addSize(4);
            return dest;
        }
        throw new IllegalArgumentException("Invalid unicode character value " + cp);
    }

    private static int codePointAt(CharSequence seq, int index, int end) {
        if (index < end) {
            char c1;
            if ((c1 = seq.charAt(index++)) < '\ud800' || c1 > '\udfff') {
                return c1;
            }
            if (c1 <= '\udbff') {
                if (index == end) {
                    return -c1;
                }
                char c2 = seq.charAt(index);
                if (Character.isLowSurrogate(c2)) {
                    return Character.toCodePoint(c1, c2);
                }
                throw new IllegalArgumentException("Expected low surrogate but got char '" + c2 + "' with value " + c2 + " at index " + index + " in '" + seq + "'");
            }
            throw new IllegalArgumentException("Unexpected low surrogate character '" + c1 + "' with value " + c1 + " at index " + (index - 1) + " in '" + seq + "'");
        }
        throw new IndexOutOfBoundsException("Index exceeds specified range");
    }

    private static char[] growBuffer(char[] dest, int index, int size) {
        if (size < 0) {
            throw new AssertionError((Object)"Cannot increase internal buffer any further");
        }
        char[] copy = new char[size];
        if (index > 0) {
            System.arraycopy(dest, 0, copy, 0, index);
        }
        return copy;
    }
}

