/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.baggage;

import datadog.trace.api.Config;
import ddtrot.dd.context.Context;
import ddtrot.dd.context.propagation.CarrierSetter;
import ddtrot.dd.context.propagation.CarrierVisitor;
import ddtrot.dd.context.propagation.Propagator;
import ddtrot.dd.trace.bootstrap.instrumentation.api.BaggageContext;
import ddtrot.dd.trace.core.util.EscapedData;
import ddtrot.dd.trace.core.util.PercentEscaper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class BaggagePropagator
implements Propagator {
    private static final Logger log = LoggerFactory.getLogger(BaggagePropagator.class);
    private static final PercentEscaper UTF_ESCAPER = PercentEscaper.create();
    static final String BAGGAGE_KEY = "baggage";
    private final Config config;
    private final boolean injectBaggage;
    private final boolean extractBaggage;

    public BaggagePropagator(Config config) {
        this.injectBaggage = config.isBaggageInject();
        this.extractBaggage = config.isBaggageExtract();
        this.config = config;
    }

    public BaggagePropagator(boolean injectBaggage, boolean extractBaggage) {
        this.injectBaggage = injectBaggage;
        this.extractBaggage = extractBaggage;
        this.config = Config.get();
    }

    @Override
    public <C> void inject(Context context, C carrier, CarrierSetter<C> setter) {
        int maxItems = this.config.getTraceBaggageMaxItems();
        int maxBytes = this.config.getTraceBaggageMaxBytes();
        if (!this.injectBaggage || maxItems == 0 || maxBytes == 0 || context == null || carrier == null || setter == null) {
            return;
        }
        BaggageContext baggageContext = BaggageContext.fromContext(context);
        if (baggageContext == null) {
            log.debug("BaggageContext instance is missing from the following context {}", (Object)context);
            return;
        }
        String baggageHeader = baggageContext.getW3cBaggageHeader();
        if (baggageHeader != null) {
            setter.set(carrier, BAGGAGE_KEY, baggageHeader);
            return;
        }
        int processedBaggage = 0;
        int currentBytes = 0;
        StringBuilder baggageText = new StringBuilder();
        for (Map.Entry<String, String> entry : baggageContext.asMap().entrySet()) {
            int extraBytes = 1;
            if (processedBaggage != 0) {
                baggageText.append(',');
                ++extraBytes;
            }
            EscapedData escapedKey = UTF_ESCAPER.escapeKey(entry.getKey());
            EscapedData escapedVal = UTF_ESCAPER.escapeValue(entry.getValue());
            baggageText.append(escapedKey.getData());
            baggageText.append('=');
            baggageText.append(escapedVal.getData());
            if (++processedBaggage == maxItems) break;
            if (currentBytes + escapedKey.getSize() + escapedVal.getSize() + extraBytes > maxBytes) {
                baggageText.setLength(currentBytes);
                break;
            }
            currentBytes += escapedKey.getSize() + escapedVal.getSize() + extraBytes;
        }
        String baggageString = baggageText.toString();
        baggageContext.setW3cBaggageHeader(baggageString);
        setter.set(carrier, BAGGAGE_KEY, baggageString);
    }

    @Override
    public <C> Context extract(Context context, C carrier, CarrierVisitor<C> visitor) {
        if (!this.extractBaggage || context == null || carrier == null || visitor == null) {
            return context;
        }
        BaggageContextExtractor baggageContextExtractor = new BaggageContextExtractor();
        visitor.forEachKeyValue(carrier, baggageContextExtractor);
        BaggageContext extractedContext = baggageContextExtractor.extractedContext;
        if (extractedContext == null) {
            return context;
        }
        return extractedContext.storeInto(context);
    }

    public static class BaggageContextExtractor
    implements BiConsumer<String, String> {
        private BaggageContext extractedContext;

        BaggageContextExtractor() {
        }

        private String decode(String value) {
            String decoded = value;
            try {
                decoded = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                log.debug("Failed to decode {}", (Object)value);
            }
            return decoded;
        }

        private Map<String, String> parseBaggageHeaders(String input) {
            HashMap<String, String> baggage = new HashMap<String, String>();
            int keyValueSeparator = 61;
            int pairSeparator = 44;
            int start = 0;
            int pairSeparatorInd = input.indexOf(pairSeparator);
            pairSeparatorInd = pairSeparatorInd == -1 ? input.length() : pairSeparatorInd;
            int kvSeparatorInd = input.indexOf(keyValueSeparator);
            while (kvSeparatorInd != -1) {
                int end = pairSeparatorInd;
                if (kvSeparatorInd > end) {
                    log.debug("Dropping baggage headers due to key with no value {}", (Object)input.substring(start, end));
                    return Collections.emptyMap();
                }
                String key = this.decode(input.substring(start, kvSeparatorInd).trim());
                String value = this.decode(input.substring(kvSeparatorInd + 1, end).trim());
                if (key.isEmpty() || value.isEmpty()) {
                    log.debug("Dropping baggage headers due to empty k/v {}:{}", (Object)key, (Object)value);
                    return Collections.emptyMap();
                }
                baggage.put(key, value);
                kvSeparatorInd = input.indexOf(keyValueSeparator, pairSeparatorInd + 1);
                pairSeparatorInd = input.indexOf(pairSeparator, pairSeparatorInd + 1);
                pairSeparatorInd = pairSeparatorInd == -1 ? input.length() : pairSeparatorInd;
                start = end + 1;
            }
            return baggage;
        }

        @Override
        public void accept(String key, String value) {
            Map<String, String> baggage;
            if (key != null && key.equalsIgnoreCase(BaggagePropagator.BAGGAGE_KEY) && !(baggage = this.parseBaggageHeaders(value)).isEmpty()) {
                this.extractedContext = BaggageContext.create(baggage, value);
            }
        }
    }
}

