/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.timgroup.statsd;

import ddtrot.com.timgroup.statsd.DirectStatsDClient;
import ddtrot.com.timgroup.statsd.Message;
import ddtrot.com.timgroup.statsd.NonBlockingStatsDClient;
import ddtrot.com.timgroup.statsd.NonBlockingStatsDClientBuilder;
import ddtrot.com.timgroup.statsd.StatsDClientException;
import ddtrot.com.timgroup.statsd.Utf8;

class NonBlockingDirectStatsDClient
extends NonBlockingStatsDClient
implements DirectStatsDClient {
    public NonBlockingDirectStatsDClient(NonBlockingStatsDClientBuilder builder) throws StatsDClientException {
        super(builder);
    }

    @Override
    public void recordDistributionValues(String aspect, double[] values, double sampleRate, String ... tags) {
        if (values != null && values.length > 0) {
            this.sendMetric(new DoublesStatsDMessage(aspect, Message.Type.DISTRIBUTION, values, sampleRate, 0L, tags));
        }
    }

    @Override
    public void recordDistributionValues(String aspect, long[] values, double sampleRate, String ... tags) {
        if (values != null && values.length > 0) {
            this.sendMetric(new LongsStatsDMessage(aspect, Message.Type.DISTRIBUTION, values, sampleRate, 0L, tags));
        }
    }

    final class DoublesStatsDMessage
    extends MultiValuedStatsDMessage {
        private final double[] values;

        DoublesStatsDMessage(String aspect, Message.Type type, double[] values, double sampleRate, long timestamp, String[] tags) {
            super(aspect, type, tags, sampleRate, timestamp);
            this.values = values;
        }

        @Override
        protected int lengthOfValues() {
            return this.values.length;
        }

        @Override
        protected void writeValueTo(StringBuilder buffer, int index) {
            buffer.append(this.values[index]);
        }
    }

    final class LongsStatsDMessage
    extends MultiValuedStatsDMessage {
        private final long[] values;

        LongsStatsDMessage(String aspect, Message.Type type, long[] values, double sampleRate, long timestamp, String[] tags) {
            super(aspect, type, tags, sampleRate, timestamp);
            this.values = values;
        }

        @Override
        protected int lengthOfValues() {
            return this.values.length;
        }

        @Override
        protected void writeValueTo(StringBuilder buffer, int index) {
            buffer.append(this.values[index]);
        }
    }

    abstract class MultiValuedStatsDMessage
    extends Message {
        private final double sampleRate;
        private final long timestamp;
        private int metadataSize;
        private int offset;

        MultiValuedStatsDMessage(String aspect, Message.Type type, String[] tags, double sampleRate, long timestamp) {
            super(aspect, type, tags);
            this.metadataSize = -1;
            this.offset = 0;
            this.sampleRate = sampleRate;
            this.timestamp = timestamp;
        }

        @Override
        public final boolean canAggregate() {
            return false;
        }

        @Override
        public final void aggregate(Message message) {
        }

        @Override
        public final boolean writeTo(StringBuilder builder, int capacity, String containerID) {
            int metadataSize = this.metadataSize(builder, containerID);
            this.writeHeadMetadata(builder);
            boolean partialWrite = this.writeValuesTo(builder, capacity - metadataSize);
            this.writeTailMetadata(builder, containerID);
            return partialWrite;
        }

        private int metadataSize(StringBuilder builder, String containerID) {
            if (this.metadataSize == -1) {
                int previousLength = builder.length();
                int previousEncodedLength = Utf8.encodedLength(builder);
                this.writeHeadMetadata(builder);
                this.writeTailMetadata(builder, containerID);
                this.metadataSize = Utf8.encodedLength(builder) - previousEncodedLength;
                builder.setLength(previousLength);
            }
            return this.metadataSize;
        }

        private void writeHeadMetadata(StringBuilder builder) {
            builder.append(NonBlockingDirectStatsDClient.this.prefix).append(this.aspect);
        }

        private void writeTailMetadata(StringBuilder builder, String containerID) {
            builder.append('|').append((Object)this.type);
            if (!Double.isNaN(this.sampleRate)) {
                builder.append('|').append('@').append(NonBlockingStatsDClient.format(NonBlockingStatsDClient.SAMPLE_RATE_FORMATTER, this.sampleRate));
            }
            if (this.timestamp != 0L) {
                builder.append("|T").append(this.timestamp);
            }
            NonBlockingDirectStatsDClient.this.tagString(this.tags, builder);
            if (containerID != null && !containerID.isEmpty()) {
                builder.append("|c:").append(containerID);
            }
            builder.append('\n');
        }

        private boolean writeValuesTo(StringBuilder builder, int remainingCapacity) {
            if (this.offset >= this.lengthOfValues()) {
                return false;
            }
            int maxLength = builder.length() + remainingCapacity;
            builder.append(':');
            this.writeValueTo(builder, this.offset);
            int previousLength = builder.length();
            for (int i = this.offset + 1; i < this.lengthOfValues(); ++i) {
                builder.append(':');
                this.writeValueTo(builder, i);
                if (builder.length() > maxLength) {
                    builder.setLength(previousLength);
                    this.offset = i;
                    return true;
                }
                previousLength = builder.length();
            }
            this.offset = this.lengthOfValues();
            return false;
        }

        protected abstract int lengthOfValues();

        protected abstract void writeValueTo(StringBuilder var1, int var2);
    }
}

