/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.common.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;

final class TunnelingJdkSocket
extends Socket {
    private final SocketAddress unixSocketAddress;
    private InetSocketAddress inetSocketAddress;
    private SocketChannel unixSocketChannel;
    private int timeout;
    private boolean shutIn;
    private boolean shutOut;
    private boolean closed;
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    private int sendBufferSize = -1;
    private int receiveBufferSize = -1;

    TunnelingJdkSocket(Path path) {
        this.unixSocketAddress = UnixDomainSocketAddress.of(path);
    }

    TunnelingJdkSocket(Path path, InetSocketAddress address) {
        this(path);
        this.inetSocketAddress = address;
    }

    @Override
    public boolean isConnected() {
        return null != this.unixSocketChannel;
    }

    @Override
    public boolean isInputShutdown() {
        return this.shutIn;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.shutOut;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("Socket timeout can't be negative");
        }
        this.timeout = timeout;
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        return this.timeout;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isConnected()) {
            throw new SocketException("Socket is already connected");
        }
        this.inetSocketAddress = (InetSocketAddress)endpoint;
        this.unixSocketChannel = SocketChannel.open(this.unixSocketAddress);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.isConnected()) {
            throw new SocketException("Socket is already connected");
        }
        this.inetSocketAddress = (InetSocketAddress)endpoint;
        this.unixSocketChannel = SocketChannel.open(this.unixSocketAddress);
    }

    @Override
    public SocketChannel getChannel() {
        return this.unixSocketChannel;
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Invalid send buffer size");
        }
        try {
            this.unixSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)size);
            this.sendBufferSize = size;
        }
        catch (IOException e) {
            throw new SocketException("Failed to set send buffer size");
        }
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.sendBufferSize == -1) {
            return 8192;
        }
        return this.sendBufferSize;
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Invalid receive buffer size");
        }
        try {
            this.unixSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)size);
            this.receiveBufferSize = size;
        }
        catch (IOException e) {
            throw new SocketException("Failed to set receive buffer size");
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.receiveBufferSize == -1) {
            return 8192;
        }
        return this.receiveBufferSize;
    }

    public int getStreamBufferSize() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (this.sendBufferSize == -1 && this.receiveBufferSize == -1) {
            return 8192;
        }
        return Math.max(this.sendBufferSize, this.receiveBufferSize);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return new InputStream(){
            private final ByteBuffer buffer;
            private final Selector selector;
            {
                this.buffer = ByteBuffer.allocate(TunnelingJdkSocket.this.getStreamBufferSize());
                this.selector = Selector.open();
                TunnelingJdkSocket.this.unixSocketChannel.configureBlocking(false);
                TunnelingJdkSocket.this.unixSocketChannel.register(this.selector, 1);
            }

            @Override
            public int read() throws IOException {
                byte[] nextByte = new byte[1];
                return this.read(nextByte, 0, 1) == -1 ? -1 : nextByte[0] & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.buffer.clear();
                int readyChannels = this.selector.select(TunnelingJdkSocket.this.timeout);
                if (readyChannels == 0) {
                    return 0;
                }
                Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> keyIterator = selectedKeys.iterator();
                while (keyIterator.hasNext()) {
                    SelectionKey key = keyIterator.next();
                    keyIterator.remove();
                    if (!key.isReadable()) continue;
                    int r = TunnelingJdkSocket.this.unixSocketChannel.read(this.buffer);
                    if (r == -1) {
                        return -1;
                    }
                    this.buffer.flip();
                    len = Math.min(r, len);
                    this.buffer.get(b, off, len);
                    return len;
                }
                return 0;
            }

            @Override
            public void close() throws IOException {
                this.selector.close();
            }
        };
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                byte[] array = ByteBuffer.allocate(4).putInt(b).array();
                this.write(array, 0, 4);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
                while (buffer.hasRemaining()) {
                    TunnelingJdkSocket.this.unixSocketChannel.write(buffer);
                }
            }
        };
    }

    @Override
    public void shutdownInput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is already shutdown");
        }
        this.unixSocketChannel.shutdownInput();
        this.shutIn = true;
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is already shutdown");
        }
        this.unixSocketChannel.shutdownOutput();
        this.shutOut = true;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.inetSocketAddress.getAddress();
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (null != this.unixSocketChannel) {
            this.unixSocketChannel.close();
        }
        this.closed = true;
    }
}

