/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.git;

import ddtrot.dd.trace.api.git.CommitInfo;
import ddtrot.dd.trace.api.git.GitInfo;
import ddtrot.dd.trace.api.git.GitInfoBuilder;
import ddtrot.dd.trace.api.git.PersonInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedGitInfoBuilder
implements GitInfoBuilder {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedGitInfoBuilder.class);
    private final List<String> resourceNames;

    public EmbeddedGitInfoBuilder() {
        this(Arrays.asList("BOOT-INF/classes/datadog_git.properties", "BOOT-INF/classes/git.properties", "WEB-INF/classes/datadog_git.properties", "WEB-INF/classes/git.properties", "datadog_git.properties"));
    }

    EmbeddedGitInfoBuilder(List<String> resourceNames) {
        this.resourceNames = resourceNames;
    }

    @Override
    public GitInfo build(@Nullable String repositoryPath) {
        String authorTime;
        String committerTime;
        String commitSha;
        Properties gitProperties = new Properties();
        for (String resourceName : this.resourceNames) {
            try {
                InputStream is = ClassLoader.getSystemResourceAsStream(resourceName);
                Throwable throwable = null;
                try {
                    if (is != null) {
                        gitProperties.load(is);
                        break;
                    }
                    log.debug("Could not find embedded Git properties resource: {}", (Object)resourceName);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                log.error("Error reading embedded Git properties from {}", (Object)resourceName, (Object)e);
            }
        }
        if ((commitSha = gitProperties.getProperty("git.commit.id")) == null) {
            commitSha = gitProperties.getProperty("git.commit.id.full");
        }
        if ((committerTime = gitProperties.getProperty("git.commit.committer.time")) == null) {
            committerTime = gitProperties.getProperty("git.commit.time");
        }
        if ((authorTime = gitProperties.getProperty("git.commit.author.time")) == null) {
            authorTime = gitProperties.getProperty("git.commit.time");
        }
        return new GitInfo(gitProperties.getProperty("git.remote.origin.url"), gitProperties.getProperty("git.branch"), gitProperties.getProperty("git.tags"), new CommitInfo(commitSha, new PersonInfo(gitProperties.getProperty("git.commit.user.name"), gitProperties.getProperty("git.commit.user.email"), authorTime), new PersonInfo(gitProperties.getProperty("git.commit.user.name"), gitProperties.getProperty("git.commit.user.email"), committerTime), gitProperties.getProperty("git.commit.message.full")));
    }

    @Override
    public int order() {
        return Integer.MAX_VALUE;
    }
}

