/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.config.provider;

import ddtrot.dd.cli.CLIHelper;
import ddtrot.dd.trace.bootstrap.config.provider.StableConfigSource;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfigyaml.ConfigurationMap;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfigyaml.Rule;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfigyaml.Selector;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfigyaml.StableConfigYaml;
import ddtrot.dd.yaml.YamlParser;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableConfigParser {
    private static final Logger log = LoggerFactory.getLogger(StableConfigParser.class);
    private static final Set<String> VM_ARGS = new HashSet<String>(CLIHelper.getVmArgs());

    public static StableConfigSource.StableConfig parse(String filePath) throws IOException {
        try {
            StableConfigYaml data = YamlParser.parse(filePath, StableConfigYaml.class);
            String configId = data.getConfig_id();
            ConfigurationMap configMap = data.getApm_configuration_default();
            List<Rule> rules = data.getApm_configuration_rules();
            if (!rules.isEmpty()) {
                for (Rule rule : rules) {
                    if (!StableConfigParser.doesRuleMatch(rule)) continue;
                    configMap.putAll(rule.getConfiguration());
                    return StableConfigParser.createStableConfig(configId, configMap);
                }
            }
            if (!configMap.isEmpty()) {
                return StableConfigParser.createStableConfig(configId, configMap);
            }
            if (configId != null) {
                return new StableConfigSource.StableConfig(configId, Collections.emptyMap());
            }
        }
        catch (IOException e) {
            log.debug("Stable configuration file either not found or not readable at filepath {}", (Object)filePath);
        }
        return StableConfigSource.StableConfig.EMPTY;
    }

    private static boolean doesRuleMatch(Rule rule) {
        for (Selector selector : rule.getSelectors()) {
            if (StableConfigParser.selectorMatch(selector.getOrigin(), selector.getMatches(), selector.getOperator(), selector.getKey())) continue;
            return false;
        }
        return true;
    }

    private static StableConfigSource.StableConfig createStableConfig(String configId, ConfigurationMap configMap) {
        return new StableConfigSource.StableConfig(configId, new HashMap<String, Object>(configMap));
    }

    private static boolean validOperatorForLanguageOrigin(String operator) {
        switch (operator = operator.toLowerCase()) {
            case "equals": 
            case "starts_with": 
            case "ends_with": 
            case "contains": {
                return true;
            }
        }
        return false;
    }

    private static boolean checkEnvMatches(List<String> values, List<String> matches, BiPredicate<String, String> compareFunc) {
        if (values == null) {
            return false;
        }
        for (String match : matches) {
            if (match == null) continue;
            for (String value : values) {
                if (!compareFunc.test(value, match.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean selectorMatch(String origin, List<String> matches, String operator, String key) {
        switch (origin.toLowerCase()) {
            case "language": {
                if (!StableConfigParser.validOperatorForLanguageOrigin(operator)) {
                    return false;
                }
                for (String entry : matches) {
                    if (!entry.toLowerCase().contains("java")) continue;
                    return true;
                }
            }
            case "environment_variables": {
                if (key == null) {
                    return false;
                }
                String envValue = System.getenv(key.toUpperCase());
                if (envValue == null) {
                    return false;
                }
                envValue = envValue.toLowerCase();
                switch (operator.toLowerCase()) {
                    case "exists": {
                        return true;
                    }
                    case "equals": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::equalsIgnoreCase);
                    }
                    case "starts_with": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::startsWith);
                    }
                    case "ends_with": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::endsWith);
                    }
                    case "contains": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::contains);
                    }
                }
                return false;
            }
            case "process_arguments": {
                return VM_ARGS.contains(key);
            }
            case "tags": {
                return false;
            }
        }
        return false;
    }
}

