/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import ddtrot.dd.trace.common.sampling.RateSampler;
import ddtrot.dd.trace.core.CoreSpan;

public abstract class DeterministicSampler
implements RateSampler {
    private static final long KNUTH_FACTOR = 1111111111111111111L;
    private static final double MAX = Math.pow(2.0, 64.0) - 1.0;
    private final float rate;
    private final long threshold;

    public DeterministicSampler(double rate) {
        this.rate = (float)rate;
        this.threshold = DeterministicSampler.cutoff(rate);
    }

    @Override
    public <T extends CoreSpan<T>> boolean sample(T span) {
        return this.getSamplingId(span) * 1111111111111111111L + Long.MIN_VALUE < this.threshold;
    }

    protected abstract <T extends CoreSpan<T>> long getSamplingId(T var1);

    @Override
    public double getSampleRate() {
        return this.rate;
    }

    public static long cutoff(double rate) {
        if (rate < 0.5) {
            return (long)(rate * MAX) + Long.MIN_VALUE;
        }
        if (rate < 1.0) {
            return (long)(rate * MAX + -9.223372036854776E18);
        }
        return Long.MAX_VALUE;
    }

    public static final class SpanSampler
    extends DeterministicSampler {
        public SpanSampler(double rate) {
            super(rate);
        }

        @Override
        protected <T extends CoreSpan<T>> long getSamplingId(T span) {
            return span.getSpanId();
        }
    }

    public static final class TraceSampler
    extends DeterministicSampler {
        public TraceSampler(double rate) {
            super(rate);
        }

        @Override
        protected <T extends CoreSpan<T>> long getSamplingId(T span) {
            return span.getTraceId().toLong();
        }
    }
}

