/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.scopemanager;

import datadog.trace.api.Stateful;
import ddtrot.dd.context.Context;
import ddtrot.dd.trace.api.scopemanager.ExtendedScopeListener;
import ddtrot.dd.trace.api.scopemanager.ScopeListener;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.core.scopemanager.ContinuableScopeManager;
import ddtrot.dd.trace.core.scopemanager.ScopeStack;

class ContinuableScope
implements AgentScope {
    static final byte INSTRUMENTATION = 0;
    static final byte MANUAL = 1;
    static final byte ITERATION = 2;
    static final byte CONTEXT = 3;
    private final ContinuableScopeManager scopeManager;
    final Context context;
    private static final byte ASYNC_PROPAGATING = 1;
    private static final byte CHECKPOINTED = 2;
    private byte flags;
    private final byte source;
    private short referenceCount = 1;
    private final Stateful scopeState;

    ContinuableScope(ContinuableScopeManager scopeManager, Context context, byte source, boolean isAsyncPropagating, Stateful scopeState) {
        this.scopeManager = scopeManager;
        this.context = context;
        this.source = source;
        this.flags = isAsyncPropagating ? (byte)1 : 0;
        this.scopeState = scopeState;
    }

    @Override
    public final void close() {
        ScopeStack scopeStack = this.scopeManager.scopeStack();
        if (!scopeStack.checkTop(this) && !scopeStack.checkOverdueScopes(this)) {
            if (ContinuableScopeManager.log.isDebugEnabled()) {
                ContinuableScopeManager.log.debug("Tried to close {} scope when not on top.  Current top: {}", (Object)this, (Object)scopeStack.top);
            }
            byte source = this.source();
            this.scopeManager.healthMetrics.onScopeCloseError(source == 1);
            if (source == 1 && this.scopeManager.strictMode) {
                throw new RuntimeException("Tried to close " + this.context + " scope when not on top");
            }
        }
        boolean alive = this.decrementReferences();
        this.scopeManager.healthMetrics.onCloseScope();
        if (!alive) {
            this.scopeState.close();
            this.cleanup(scopeStack);
        }
    }

    void cleanup(ScopeStack scopeStack) {
        scopeStack.cleanup();
    }

    final void onProperClose() {
        for (ScopeListener scopeListener : this.scopeManager.scopeListeners) {
            try {
                scopeListener.afterScopeClosed();
            }
            catch (Exception e) {
                ContinuableScopeManager.log.debug("ScopeListener threw exception in close()", (Throwable)e);
            }
        }
        for (ExtendedScopeListener extendedScopeListener : this.scopeManager.extendedScopeListeners) {
            try {
                extendedScopeListener.afterScopeClosed();
            }
            catch (Exception e) {
                ContinuableScopeManager.log.debug("ScopeListener threw exception in close()", (Throwable)e);
            }
        }
    }

    final void incrementReferences() {
        this.referenceCount = (short)(this.referenceCount + 1);
    }

    final boolean decrementReferences() {
        this.referenceCount = (short)(this.referenceCount - 1);
        return this.referenceCount > 0;
    }

    final void clearReferences() {
        this.referenceCount = 0;
    }

    final boolean alive() {
        return this.referenceCount > 0;
    }

    public final boolean isAsyncPropagating() {
        return (this.flags & 1) != 0;
    }

    @Override
    public final AgentSpan span() {
        return AgentSpan.fromContext(this.context);
    }

    @Override
    public Context context() {
        return this.context;
    }

    public final void setAsyncPropagation(boolean value) {
        this.flags = value ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public final String toString() {
        return super.toString() + "->" + this.context;
    }

    public void checkpoint() {
        this.flags = (byte)(this.flags | 2);
    }

    public boolean rollback() {
        if ((this.flags & 2) != 0) {
            this.flags = (byte)(this.flags & 0xFFFFFFFD);
            return false;
        }
        return true;
    }

    public final void beforeActivated() {
        AgentSpan span = this.span();
        if (span == null) {
            return;
        }
        try {
            this.scopeState.activate(span.context());
        }
        catch (Throwable e) {
            ContinuableScopeManager.ratelimitedLog.warn("ScopeState {} threw exception in beforeActivated()", this.scopeState.getClass(), e);
        }
    }

    public final void afterActivated() {
        AgentSpan span = this.span();
        if (span == null) {
            return;
        }
        for (ScopeListener scopeListener : this.scopeManager.scopeListeners) {
            try {
                scopeListener.afterScopeActivated();
            }
            catch (Throwable e) {
                ContinuableScopeManager.log.debug("ScopeListener threw exception in afterActivated()", e);
            }
        }
        for (ExtendedScopeListener extendedScopeListener : this.scopeManager.extendedScopeListeners) {
            try {
                extendedScopeListener.afterScopeActivated(span.getTraceId(), span.getSpanId());
            }
            catch (Throwable e) {
                ContinuableScopeManager.log.debug("ExtendedScopeListener threw exception in afterActivated()", e);
            }
        }
    }

    public byte source() {
        return (byte)(this.source & 0x7F);
    }
}

