/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.git;

import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.api.git.CommitInfo;
import ddtrot.dd.trace.api.git.GitInfo;
import ddtrot.dd.trace.api.git.GitInfoBuilder;
import ddtrot.dd.trace.api.git.GitUtils;
import ddtrot.dd.trace.api.git.PersonInfo;
import ddtrot.dd.trace.api.git.UserSuppliedGitInfoBuilder;
import ddtrot.dd.trace.util.Strings;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class GitInfoProvider {
    public static final GitInfoProvider INSTANCE = new GitInfoProvider();
    static final String NULL_PATH_STRING;
    private volatile Collection<GitInfoBuilder> builders = Collections.emptyList();
    private final DDCache<String, GitInfo> gitInfoCache = DDCaches.newFixedSizeCache(4);

    public GitInfo getGitInfo() {
        return this.getGitInfo(null);
    }

    public GitInfo getGitInfo(@Nullable String repositoryPath) {
        if (repositoryPath == null) {
            repositoryPath = NULL_PATH_STRING;
        }
        return this.gitInfoCache.computeIfAbsent(repositoryPath, this::buildGitInfo);
    }

    private GitInfo buildGitInfo(String repositoryPath) {
        Evaluator evaluator = new Evaluator(repositoryPath, this.builders);
        return new GitInfo(evaluator.get(gi -> GitUtils.filterSensitiveInfo(gi.getRepositoryURL()), GitInfoProvider::validateGitRemoteUrl), evaluator.get(GitInfo::getBranch, Strings::isNotBlank), evaluator.get(GitInfo::getTag, Strings::isNotBlank), new CommitInfo(evaluator.get(gi1 -> gi1.getCommit().getSha(), Strings::isNotBlank), new PersonInfo(evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getAuthor().getName(), Strings::isNotBlank), evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getAuthor().getEmail(), Strings::isNotBlank), evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getAuthor().getIso8601Date(), Strings::isNotBlank)), new PersonInfo(evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getCommitter().getName(), Strings::isNotBlank), evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getCommitter().getEmail(), Strings::isNotBlank), evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getCommitter().getIso8601Date(), Strings::isNotBlank)), evaluator.getIfCommitShaMatches(gi -> gi.getCommit().getFullMessage(), Strings::isNotBlank)));
    }

    private static boolean validateGitRemoteUrl(String s) {
        return Strings.isNotBlank(s) && !s.startsWith("file:");
    }

    public synchronized void registerGitInfoBuilder(GitInfoBuilder builder) {
        ArrayList<GitInfoBuilder> updatedBuilders = new ArrayList<GitInfoBuilder>(this.builders);
        updatedBuilders.add(builder);
        updatedBuilders.sort(Comparator.comparingInt(GitInfoBuilder::order));
        this.builders = updatedBuilders;
        this.gitInfoCache.clear();
    }

    public synchronized void invalidateCache() {
        this.gitInfoCache.clear();
    }

    static {
        INSTANCE.registerGitInfoBuilder(new UserSuppliedGitInfoBuilder());
        NULL_PATH_STRING = Paths.get("", new String[0]).toAbsolutePath().toString();
    }

    private static final class Evaluator {
        private final String repositoryPath;
        private final Map<GitInfoBuilder, GitInfo> infos;

        private Evaluator(String repositoryPath, Collection<GitInfoBuilder> builders) {
            this.repositoryPath = repositoryPath;
            this.infos = new LinkedHashMap<GitInfoBuilder, GitInfo>();
            for (GitInfoBuilder builder : builders) {
                this.infos.put(builder, null);
            }
        }

        private String get(Function<GitInfo, String> function, Predicate<String> validator) {
            return this.get(function, validator, false);
        }

        private String getIfCommitShaMatches(Function<GitInfo, String> function, Predicate<String> validator) {
            return this.get(function, validator, true);
        }

        private String get(Function<GitInfo, String> function, Predicate<String> validator, boolean checkShaIntegrity) {
            String commitSha = null;
            for (Map.Entry<GitInfoBuilder, GitInfo> e : this.infos.entrySet()) {
                String result;
                GitInfo info = e.getValue();
                if (info == null) {
                    GitInfoBuilder builder = e.getKey();
                    info = builder.build(this.repositoryPath);
                    e.setValue(info);
                }
                if (checkShaIntegrity) {
                    String currentCommitSha;
                    CommitInfo currentCommit = info.getCommit();
                    String string = currentCommitSha = currentCommit != null ? currentCommit.getSha() : null;
                    if (Strings.isNotBlank(currentCommitSha)) {
                        if (commitSha == null) {
                            commitSha = currentCommitSha;
                        } else if (!commitSha.equals(currentCommitSha)) continue;
                    }
                }
                if (!validator.test(result = function.apply(info))) continue;
                return result;
            }
            return null;
        }
    }
}

