/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.config.provider;

import ddtrot.dd.trace.bootstrap.config.provider.StableConfigSource;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfigyaml.ConfigurationMap;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfigyaml.Rule;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfigyaml.Selector;
import ddtrot.dd.trace.bootstrap.config.provider.stableconfigyaml.StableConfigYaml;
import ddtrot.dd.yaml.YamlParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableConfigParser {
    private static final Logger log = LoggerFactory.getLogger(StableConfigParser.class);
    private static final String ENVIRONMENT_VARIABLES_PREFIX = "environment_variables['";
    private static final String PROCESS_ARGUMENTS_PREFIX = "process_arguments['";
    private static final String UNDEFINED_VALUE = "UNDEFINED";

    public static StableConfigSource.StableConfig parse(String filePath) throws IOException {
        try {
            String content = new String(Files.readAllBytes(Paths.get(filePath, new String[0])), StandardCharsets.UTF_8);
            String processedContent = StableConfigParser.processTemplate(content);
            StableConfigYaml data = YamlParser.parse(processedContent, StableConfigYaml.class);
            String configId = data.getConfig_id();
            ConfigurationMap configMap = data.getApm_configuration_default();
            List<Rule> rules = data.getApm_configuration_rules();
            if (!rules.isEmpty()) {
                for (Rule rule : rules) {
                    if (!StableConfigParser.doesRuleMatch(rule)) continue;
                    configMap.putAll(rule.getConfiguration());
                    return StableConfigParser.createStableConfig(configId, configMap);
                }
            }
            if (!configMap.isEmpty()) {
                return StableConfigParser.createStableConfig(configId, configMap);
            }
            if (configId != null) {
                return new StableConfigSource.StableConfig(configId, Collections.emptyMap());
            }
        }
        catch (IOException e) {
            log.debug("Stable configuration file either not found or not readable at filepath {}. Error: {}", (Object)filePath, (Object)e.getMessage());
        }
        return StableConfigSource.StableConfig.EMPTY;
    }

    private static boolean doesRuleMatch(Rule rule) {
        for (Selector selector : rule.getSelectors()) {
            if (StableConfigParser.selectorMatch(selector.getOrigin(), selector.getMatches(), selector.getOperator(), selector.getKey())) continue;
            return false;
        }
        return true;
    }

    private static StableConfigSource.StableConfig createStableConfig(String configId, ConfigurationMap configMap) {
        return new StableConfigSource.StableConfig(configId, new HashMap<String, Object>(configMap));
    }

    private static boolean validOperatorForLanguageOrigin(String operator) {
        switch (operator = operator.toLowerCase()) {
            case "equals": 
            case "starts_with": 
            case "ends_with": 
            case "contains": {
                return true;
            }
        }
        return false;
    }

    private static boolean checkEnvMatches(List<String> values, List<String> matches, BiPredicate<String, String> compareFunc) {
        if (values == null) {
            return false;
        }
        for (String match : matches) {
            if (match == null) continue;
            for (String value : values) {
                if (!compareFunc.test(value, match.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean selectorMatch(String origin, List<String> matches, String operator, String key) {
        switch (origin.toLowerCase()) {
            case "language": {
                if (!StableConfigParser.validOperatorForLanguageOrigin(operator)) {
                    return false;
                }
                for (String entry : matches) {
                    if (!entry.toLowerCase().contains("java")) continue;
                    return true;
                }
            }
            case "environment_variables": {
                if (key == null) {
                    return false;
                }
                String envValue = System.getenv(key.toUpperCase());
                if (envValue == null) {
                    return false;
                }
                envValue = envValue.toLowerCase();
                switch (operator.toLowerCase()) {
                    case "exists": {
                        return true;
                    }
                    case "equals": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::equalsIgnoreCase);
                    }
                    case "starts_with": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::startsWith);
                    }
                    case "ends_with": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::endsWith);
                    }
                    case "contains": {
                        return StableConfigParser.checkEnvMatches(Collections.singletonList(envValue), matches, String::contains);
                    }
                }
                return false;
            }
            case "process_arguments": {
                if (!key.startsWith("-D")) {
                    log.warn("Ignoring unsupported process_arguments entry in selector match, '{}'. Only system properties specified with the '-D' prefix are supported.", (Object)key);
                    return false;
                }
                return System.getProperty(key.substring(2)) != null;
            }
            case "tags": {
                return false;
            }
        }
        return false;
    }

    static String processTemplate(String content) throws IOException {
        int closeIndex;
        int openIndex = content.indexOf("{{");
        if (openIndex == -1) {
            return content;
        }
        StringBuilder result = new StringBuilder(content.length());
        result.append(content, 0, openIndex);
        while (true) {
            if ((closeIndex = content.indexOf("}}", openIndex)) == -1) {
                throw new IOException("Unterminated template in config");
            }
            String templateVar = content.substring(openIndex + 2, closeIndex).trim();
            String value = StableConfigParser.processTemplateVar(templateVar);
            result.append(value);
            openIndex = content.indexOf("{{", closeIndex);
            if (openIndex == -1) break;
            result.append(content, closeIndex + 2, openIndex);
        }
        result.append(content, closeIndex + 2, content.length());
        return result.toString();
    }

    private static String processTemplateVar(String templateVar) throws IOException {
        if (templateVar.startsWith(ENVIRONMENT_VARIABLES_PREFIX) && templateVar.endsWith("']")) {
            String envVar = templateVar.substring(ENVIRONMENT_VARIABLES_PREFIX.length(), templateVar.length() - 2).trim();
            if (envVar.isEmpty()) {
                throw new IOException("Empty environment variable name in template");
            }
            String value = System.getenv(envVar.toUpperCase());
            if (value == null || value.isEmpty()) {
                return UNDEFINED_VALUE;
            }
            return value;
        }
        if (templateVar.startsWith(PROCESS_ARGUMENTS_PREFIX) && templateVar.endsWith("']")) {
            String processArg = templateVar.substring(PROCESS_ARGUMENTS_PREFIX.length(), templateVar.length() - 2).trim();
            if (processArg.isEmpty()) {
                throw new IOException("Empty process argument in template");
            }
            if (!processArg.startsWith("-D")) {
                log.warn("Ignoring unsupported process_arguments entry in template variable, '{}'. Only system properties specified with the '-D' prefix are supported.", (Object)processArg);
                return UNDEFINED_VALUE;
            }
            String value = System.getProperty(processArg.substring(2));
            if (value == null || value.isEmpty()) {
                return UNDEFINED_VALUE;
            }
            return value;
        }
        return UNDEFINED_VALUE;
    }
}

