/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public final class Strings {
    private static final byte[] HEX_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static String toEnvVar(String string) {
        return string.replace('.', '_').replace('-', '_').toUpperCase();
    }

    public static String toEnvVarLowerCase(String string) {
        return string.replace('.', '_').replace('-', '_').toLowerCase();
    }

    public static String getResourceName(String className) {
        if (!className.endsWith(".class")) {
            return className.replace('.', '/') + ".class";
        }
        return className;
    }

    public static String getClassName(String resourceName) {
        if (resourceName.endsWith(".class")) {
            return resourceName.substring(0, resourceName.length() - 6).replace('/', '.');
        }
        return resourceName.replace('/', '.');
    }

    public static String getInternalName(String className) {
        return className.replace('.', '/');
    }

    public static String getPackageName(String className) {
        int lastDot = className.lastIndexOf(46);
        return lastDot < 0 ? "" : className.substring(0, lastDot);
    }

    public static String replace(String str, String delimiter, String replacement) {
        int matchIndex;
        StringBuilder sb = new StringBuilder(str);
        int curIndex = 0;
        while ((matchIndex = sb.indexOf(delimiter, curIndex)) != -1) {
            sb.replace(matchIndex, matchIndex + delimiter.length(), replacement);
            curIndex = matchIndex + replacement.length();
        }
        return sb.toString();
    }

    public static String replaceFirst(String str, String delimiter, String replacement) {
        StringBuilder sb = new StringBuilder(str);
        int i = sb.indexOf(delimiter);
        if (i != -1) {
            sb.replace(i, i + delimiter.length(), replacement);
        }
        return sb.toString();
    }

    @Nonnull
    public static String propertyNameToEnvironmentVariableName(String setting) {
        return "DD_" + Strings.toEnvVar(setting);
    }

    @Nonnull
    public static String systemPropertyNameToEnvironmentVariableName(String setting) {
        return setting.replace('.', '_').replace('-', '_').toUpperCase();
    }

    @Nonnull
    public static String propertyNameToSystemPropertyName(String setting) {
        return "dd." + setting;
    }

    @Nonnull
    public static String normalizedHeaderTag(String str) {
        if (str.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(str.length());
        int firstNonWhiteSpace = -1;
        int lastNonWhitespace = -1;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                builder.append('_');
                continue;
            }
            firstNonWhiteSpace = firstNonWhiteSpace == -1 ? i : firstNonWhiteSpace;
            lastNonWhitespace = i;
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '/') {
                builder.append(Character.toLowerCase(c));
                continue;
            }
            builder.append('_');
        }
        if (firstNonWhiteSpace == -1) {
            return "";
        }
        str = builder.substring(firstNonWhiteSpace, lastNonWhitespace + 1);
        return str;
    }

    @Nonnull
    public static String trim(String string) {
        return null == string ? "" : string.trim();
    }

    public static String sha256(String input) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static String truncate(String input, int limit) {
        return (String)Strings.truncate((CharSequence)input, limit);
    }

    public static CharSequence truncate(CharSequence input, int limit) {
        if (input == null || input.length() <= limit) {
            return input;
        }
        return input.subSequence(0, limit);
    }

    public static boolean isNotBlank(String s) {
        int codepoint;
        if (s == null || s.isEmpty()) {
            return false;
        }
        int length = s.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(offset);
            if (Character.isWhitespace(codepoint)) continue;
            return true;
        }
        return false;
    }

    public static String random(int length) {
        char[] c = new char[length];
        for (int i = 0; i < length; ++i) {
            c[i] = (char)(97 + ThreadLocalRandom.current().nextInt(26));
        }
        return new String(c);
    }

    public static String toHexString(byte[] value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = new byte[value.length * 2];
        for (int i = 0; i < value.length; ++i) {
            byte v = value[i];
            bytes[i * 2] = HEX_DIGITS[(v & 0xF0) >>> 4];
            bytes[i * 2 + 1] = HEX_DIGITS[v & 0xF];
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }
}

