/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitUtils;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.PersonInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.utils.PathUtils;

class AppVeyorInfo
implements CIProviderInfo {
    public static final String APPVEYOR = "APPVEYOR";
    public static final String APPVEYOR_PROVIDER_NAME = "appveyor";
    public static final String APPVEYOR_BUILD_ID = "APPVEYOR_BUILD_ID";
    public static final String APPVEYOR_REPO_NAME = "APPVEYOR_REPO_NAME";
    public static final String APPVEYOR_PIPELINE_NUMBER = "APPVEYOR_BUILD_NUMBER";
    public static final String APPVEYOR_WORKSPACE_PATH = "APPVEYOR_BUILD_FOLDER";
    public static final String APPVEYOR_REPO_PROVIDER = "APPVEYOR_REPO_PROVIDER";
    public static final String APPVEYOR_REPO_COMMIT = "APPVEYOR_REPO_COMMIT";
    public static final String APPVEYOR_REPO_BRANCH = "APPVEYOR_REPO_BRANCH";
    public static final String APPVEYOR_PULL_REQUEST_HEAD_REPO_BRANCH = "APPVEYOR_PULL_REQUEST_HEAD_REPO_BRANCH";
    public static final String APPVEYOR_REPO_TAG_NAME = "APPVEYOR_REPO_TAG_NAME";
    public static final String APPVEYOR_REPO_COMMIT_MESSAGE_SUBJECT = "APPVEYOR_REPO_COMMIT_MESSAGE";
    public static final String APPVEYOR_REPO_COMMIT_MESSAGE_BODY = "APPVEYOR_REPO_COMMIT_MESSAGE_EXTENDED";
    public static final String APPVEYOR_REPO_COMMIT_AUTHOR_NAME = "APPVEYOR_REPO_COMMIT_AUTHOR";
    public static final String APPVEYOR_REPO_COMMIT_AUTHOR_EMAIL = "APPVEYOR_REPO_COMMIT_AUTHOR_EMAIL";

    AppVeyorInfo() {
    }

    @Override
    public GitInfo buildCIGitInfo() {
        String repoProvider = System.getenv(APPVEYOR_REPO_PROVIDER);
        String tag = this.buildGitTag(repoProvider);
        String messageSubject = System.getenv(APPVEYOR_REPO_COMMIT_MESSAGE_SUBJECT);
        String messageBody = System.getenv(APPVEYOR_REPO_COMMIT_MESSAGE_BODY);
        return new GitInfo(this.buildGitRepositoryUrl(repoProvider, System.getenv(APPVEYOR_REPO_NAME)), this.buildGitBranch(repoProvider, tag), tag, new CommitInfo(this.buildGitCommit(), this.buildGitCommitAuthor(), PersonInfo.NOOP, String.format("%s%n%s", messageSubject, messageBody)));
    }

    @Override
    public CIInfo buildCIInfo() {
        String url = this.buildPipelineUrl(System.getenv(APPVEYOR_REPO_NAME), System.getenv(APPVEYOR_BUILD_ID));
        return CIInfo.builder().ciProviderName(APPVEYOR_PROVIDER_NAME).ciPipelineId(System.getenv(APPVEYOR_BUILD_ID)).ciPipelineName(System.getenv(APPVEYOR_REPO_NAME)).ciPipelineNumber(System.getenv(APPVEYOR_PIPELINE_NUMBER)).ciPipelineUrl(url).ciJobUrl(url).ciWorkspace(PathUtils.expandTilde(System.getenv(APPVEYOR_WORKSPACE_PATH))).build();
    }

    @Override
    public boolean isCI() {
        return true;
    }

    private String buildGitTag(String repoProvider) {
        if ("github".equals(repoProvider)) {
            return GitUtils.normalizeRef(System.getenv(APPVEYOR_REPO_TAG_NAME));
        }
        return null;
    }

    private String buildGitBranch(String repoProvider, String gitTag) {
        if (gitTag != null) {
            return null;
        }
        if ("github".equals(repoProvider)) {
            String branch = System.getenv(APPVEYOR_PULL_REQUEST_HEAD_REPO_BRANCH);
            if (branch == null || branch.isEmpty()) {
                branch = System.getenv(APPVEYOR_REPO_BRANCH);
            }
            return GitUtils.normalizeRef(branch);
        }
        return null;
    }

    private String buildGitCommit() {
        if ("github".equals(System.getenv(APPVEYOR_REPO_PROVIDER))) {
            return System.getenv(APPVEYOR_REPO_COMMIT);
        }
        return null;
    }

    private String buildGitRepositoryUrl(String repoProvider, String repoName) {
        if ("github".equals(repoProvider) && repoName != null && !repoName.isEmpty()) {
            return String.format("https://github.com/%s.git", repoName);
        }
        return null;
    }

    private String buildPipelineUrl(String repoName, String buildId) {
        return String.format("https://ci.appveyor.com/project/%s/builds/%s", repoName, buildId);
    }

    private PersonInfo buildGitCommitAuthor() {
        return new PersonInfo(System.getenv(APPVEYOR_REPO_COMMIT_AUTHOR_NAME), System.getenv(APPVEYOR_REPO_COMMIT_AUTHOR_EMAIL));
    }
}

