/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitUtils;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.utils.PathUtils;
import ddtrot.dd.trace.util.Strings;

class BitBucketInfo
implements CIProviderInfo {
    public static final String BITBUCKET = "BITBUCKET_BUILD_NUMBER";
    public static final String BITBUCKET_PROVIDER_NAME = "bitbucket";
    public static final String BITBUCKET_PIPELINE_ID = "BITBUCKET_PIPELINE_UUID";
    public static final String BITBUCKET_REPO_FULL_NAME = "BITBUCKET_REPO_FULL_NAME";
    public static final String BITBUCKET_BUILD_NUMBER = "BITBUCKET_BUILD_NUMBER";
    public static final String BITBUCKET_WORKSPACE_PATH = "BITBUCKET_CLONE_DIR";
    public static final String BITBUCKET_GIT_REPOSITORY_URL = "BITBUCKET_GIT_SSH_ORIGIN";
    public static final String BITBUCKET_GIT_COMMIT = "BITBUCKET_COMMIT";
    public static final String BITBUCKET_GIT_BRANCH = "BITBUCKET_BRANCH";
    public static final String BITBUCKET_GIT_TAG = "BITBUCKET_TAG";

    BitBucketInfo() {
    }

    @Override
    public GitInfo buildCIGitInfo() {
        return new GitInfo(GitUtils.filterSensitiveInfo(System.getenv(BITBUCKET_GIT_REPOSITORY_URL)), GitUtils.normalizeRef(System.getenv(BITBUCKET_GIT_BRANCH)), GitUtils.normalizeRef(System.getenv(BITBUCKET_GIT_TAG)), new CommitInfo(System.getenv(BITBUCKET_GIT_COMMIT)));
    }

    @Override
    public CIInfo buildCIInfo() {
        String repo = System.getenv(BITBUCKET_REPO_FULL_NAME);
        String number = System.getenv("BITBUCKET_BUILD_NUMBER");
        String url = this.buildPipelineUrl(repo, number);
        return CIInfo.builder().ciProviderName(BITBUCKET_PROVIDER_NAME).ciPipelineId(this.buildPipelineId()).ciPipelineName(repo).ciPipelineNumber(number).ciPipelineUrl(url).ciJobUrl(url).ciWorkspace(PathUtils.expandTilde(System.getenv(BITBUCKET_WORKSPACE_PATH))).build();
    }

    @Override
    public boolean isCI() {
        return true;
    }

    private String buildPipelineUrl(String repo, String number) {
        return String.format("https://bitbucket.org/%s/addon/pipelines/home#!/results/%s", repo, number);
    }

    private String buildPipelineId() {
        String id = System.getenv(BITBUCKET_PIPELINE_ID);
        if (id != null) {
            id = Strings.replace(id, "{", "");
            id = Strings.replace(id, "}", "");
        }
        return id;
    }
}

