/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.git.GitInfo;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.utils.CIUtils;
import java.nio.file.Path;
import java.nio.file.Paths;

class UnknownCIInfo
implements CIProviderInfo {
    public static final String UNKNOWN_PROVIDER_NAME = "unknown";
    private final String targetFolder;
    private final Path currentPath;

    UnknownCIInfo() {
        this(".git", Paths.get("", new String[0]).toAbsolutePath());
    }

    UnknownCIInfo(String targetFolder, Path currentPath) {
        this.targetFolder = targetFolder;
        this.currentPath = currentPath;
    }

    @Override
    public GitInfo buildCIGitInfo() {
        return GitInfo.NOOP;
    }

    @Override
    public CIInfo buildCIInfo() {
        Path workspace = CIUtils.findParentPathBackwards(this.getCurrentPath(), this.getTargetFolder(), true);
        if (workspace == null) {
            return CIInfo.NOOP;
        }
        return CIInfo.builder().ciWorkspace(workspace.toAbsolutePath().toString()).build();
    }

    protected String getTargetFolder() {
        return this.targetFolder;
    }

    protected Path getCurrentPath() {
        return this.currentPath;
    }

    @Override
    public boolean isCI() {
        return false;
    }
}

