/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.Entry;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.EntryBuilder;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.CharacterMatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;

public class Codeowners {
    private final String repoRoot;
    private final Iterable<Entry> entries;

    private Codeowners(String repoRoot, Iterable<Entry> entries) {
        this.repoRoot = repoRoot + (repoRoot.endsWith("/") ? "" : "/");
        this.entries = entries;
    }

    public Collection<String> getOwners(String path) {
        if (!path.startsWith(this.repoRoot)) {
            return Collections.emptyList();
        }
        char[] relativePath = new char[path.length() - this.repoRoot.length()];
        path.getChars(this.repoRoot.length(), path.length(), relativePath, 0);
        for (Entry entry : this.entries) {
            if (entry.getMatcher().consume(relativePath, 0) < 0) continue;
            return entry.getOwners();
        }
        return Collections.emptyList();
    }

    public static Codeowners parse(String repoRoot, Reader r) throws IOException {
        String s;
        ArrayDeque<Entry> entries = new ArrayDeque<Entry>();
        CharacterMatcher.Factory characterMatcherFactory = new CharacterMatcher.Factory();
        BufferedReader br = new BufferedReader(r);
        while ((s = br.readLine()) != null) {
            EntryBuilder entryBuilder = new EntryBuilder(characterMatcherFactory, s);
            Entry entry = entryBuilder.parse();
            if (entry == null) continue;
            entries.offerFirst(entry);
        }
        return new Codeowners(repoRoot, entries);
    }
}

