/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.Entry;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.AsteriskMatcher;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.CharacterMatcher;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.CompositeMatcher;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.DoubleAsteriskMatcher;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.EndOfLineMatcher;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.EndOfSegmentMatcher;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.Matcher;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.NegatingMatcher;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.QuestionMarkMatcher;
import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.RangeMatcher;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryBuilder {
    private static final Logger log = LoggerFactory.getLogger(EntryBuilder.class);
    private final CharacterMatcher.Factory characterMatcherFactory;
    private final char[] c;
    private int offset;

    public EntryBuilder(CharacterMatcher.Factory characterMatcherFactory, String s) {
        this.characterMatcherFactory = characterMatcherFactory;
        this.c = s.toCharArray();
    }

    @Nullable
    public Entry parse() {
        try {
            if (this.c.length == 0 || this.c[0] == '#') {
                return null;
            }
            Matcher matcher = this.parseMatcher();
            Collection<String> owners = this.parseOwners();
            return new Entry(matcher, owners);
        }
        catch (Exception e) {
            log.error("error parsing CODEOWNERS pattern: {}", (Object)Arrays.toString(this.c), (Object)e);
            return null;
        }
    }

    private Matcher parseMatcher() {
        boolean patternEndsWithSlash;
        if (this.c[this.offset] == '!') {
            ++this.offset;
            return new NegatingMatcher(this.parseMatcher());
        }
        boolean patternContainsSlashes = false;
        if (this.c[this.offset] == '/') {
            ++this.offset;
            patternContainsSlashes = true;
        }
        ArrayDeque<Matcher> characterMatchers = new ArrayDeque<Matcher>();
        while (this.offset < this.c.length && !this.isPatternTerminator(this.c[this.offset])) {
            if (this.consumeDoubleAsterisk()) {
                characterMatchers.offerLast(DoubleAsteriskMatcher.INSTANCE);
                patternContainsSlashes = true;
            } else if (this.c[this.offset] == '/') {
                if (this.offset + 1 < this.c.length && !this.isPatternTerminator(this.c[this.offset + 1])) {
                    characterMatchers.offerLast(this.characterMatcherFactory.create('/'));
                    patternContainsSlashes = true;
                }
            } else if (this.c[this.offset] == '*') {
                characterMatchers.offerLast(AsteriskMatcher.INSTANCE);
            } else if (this.c[this.offset] == '?') {
                characterMatchers.offerLast(QuestionMarkMatcher.INSTANCE);
            } else if (this.c[this.offset] == '[') {
                characterMatchers.offerLast(this.parseRangeCharacterMatcher());
            } else if (this.c[this.offset] == '\\') {
                characterMatchers.offerLast(this.characterMatcherFactory.create(this.c[++this.offset]));
            } else {
                characterMatchers.offerLast(this.characterMatcherFactory.create(this.c[this.offset]));
            }
            ++this.offset;
        }
        if (characterMatchers.isEmpty()) {
            throw new IllegalArgumentException("No matchers found");
        }
        boolean bl = patternEndsWithSlash = this.c[this.offset - 1] == '/';
        if (!patternEndsWithSlash) {
            if (this.c[this.offset - 1] == '*') {
                characterMatchers.offerLast(EndOfLineMatcher.INSTANCE);
            } else {
                characterMatchers.offerLast(EndOfSegmentMatcher.INSTANCE);
            }
        }
        if (!patternContainsSlashes) {
            characterMatchers.offerFirst(DoubleAsteriskMatcher.INSTANCE);
        }
        return new CompositeMatcher(characterMatchers.toArray(new Matcher[0]));
    }

    private boolean consumeDoubleAsterisk() {
        int position = this.offset;
        if (this.c[this.offset] == '/') {
            ++position;
        } else if (position > 0 && this.c[position - 1] != '!') {
            return false;
        }
        if (position == this.c.length || this.c[position++] != '*') {
            return false;
        }
        if (position == this.c.length || this.c[position++] != '*') {
            return false;
        }
        if (position == this.c.length || this.isPatternTerminator(this.c[position])) {
            this.offset = position - 1;
            return true;
        }
        if (this.c[position] == '/') {
            this.offset = position;
            return true;
        }
        return false;
    }

    private boolean isPatternTerminator(char c) {
        return c == '#' || Character.isWhitespace(c);
    }

    private Matcher parseRangeCharacterMatcher() {
        ++this.offset;
        ArrayList<RangeMatcher.Range> ranges = new ArrayList<RangeMatcher.Range>();
        while (this.offset < this.c.length) {
            if (this.c[this.offset] == ']') {
                if (!ranges.isEmpty()) {
                    return new RangeMatcher(ranges.toArray(new RangeMatcher.Range[0]));
                }
                throw new IllegalArgumentException("Empty character range");
            }
            ranges.add(this.parseRange());
            ++this.offset;
        }
        throw new IllegalArgumentException("Unterminated character range");
    }

    private RangeMatcher.Range parseRange() {
        if (this.offset + 2 >= this.c.length) {
            throw new IllegalArgumentException("Unterminated character range");
        }
        if (this.c[this.offset + 1] != '-') {
            throw new IllegalArgumentException("Malformed character range");
        }
        this.offset += 2;
        return new RangeMatcher.Range(this.c[this.offset - 2], this.c[this.offset]);
    }

    private Collection<String> parseOwners() {
        ArrayList<String> owners = new ArrayList<String>();
        while (this.offset < this.c.length) {
            int ownerIdx;
            while (this.offset < this.c.length && Character.isWhitespace(this.c[this.offset])) {
                ++this.offset;
            }
            if (this.offset == this.c.length || this.c[this.offset] == '#') break;
            for (ownerIdx = this.offset; ownerIdx < this.c.length && !this.isPatternTerminator(this.c[ownerIdx]); ++ownerIdx) {
            }
            owners.add(new String(this.c, this.offset, ownerIdx - this.offset));
            this.offset = ownerIdx;
            ++this.offset;
        }
        return owners;
    }
}

