/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher;

import ddtrot.dd.trace.bootstrap.instrumentation.ci.codeowners.matcher.Matcher;

public class RangeMatcher
implements Matcher {
    private final Range[] ranges;

    public RangeMatcher(Range ... ranges) {
        this.ranges = ranges;
    }

    @Override
    public int consume(char[] line, int offset) {
        if (offset < line.length) {
            for (Range range : this.ranges) {
                if (!range.matches(line[offset])) continue;
                return 1;
            }
        }
        return -1;
    }

    @Override
    public boolean multi() {
        return false;
    }

    public static final class Range {
        private final char from;
        private final char to;

        public Range(char from, char to) {
            if (to < from) {
                throw new IllegalArgumentException("Range is invalid: [" + from + "-" + to + "]");
            }
            this.from = from;
            this.to = to;
        }

        boolean matches(char c) {
            return c >= this.from && c <= this.to;
        }
    }
}

