/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.cli;

import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.BufferedReader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class CLIHelper {
    private static final List<String> VM_ARGS = CLIHelper.findVmArgs();

    public static List<String> getVmArgs() {
        return VM_ARGS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressForbidden
    private static List<String> findVmArgs() {
        try {
            Path cmdlinePath;
            if (CLIHelper.isLinux() && Files.exists(cmdlinePath = Paths.get("/proc/self/cmdline", new String[0]), new LinkOption[0])) {
                try (BufferedReader in = Files.newBufferedReader(cmdlinePath);){
                    List<String> list = Arrays.asList(in.readLine().split("\u0000"));
                    return list;
                }
            }
        }
        catch (Throwable cmdlinePath) {
            // empty catch block
        }
        try {
            Object vmManagement;
            Class<?> managementFactoryHelperClass = Class.forName("sun.management.ManagementFactoryHelper");
            Class<?> vmManagementClass = Class.forName("sun.management.VMManagement");
            try {
                vmManagement = managementFactoryHelperClass.getDeclaredMethod("getVMManagement", new Class[0]).invoke(null, new Object[0]);
                return (List)vmManagementClass.getMethod("getVmArguments", new Class[0]).invoke(vmManagement, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                Field field = managementFactoryHelperClass.getDeclaredField("jvm");
                field.setAccessible(true);
                vmManagement = field.get(null);
                field.setAccessible(false);
            }
            return (List)vmManagementClass.getMethod("getVmArguments", new Class[0]).invoke(vmManagement, new Object[0]);
        }
        catch (ReflectiveOperationException | UnsatisfiedLinkError managementFactoryHelperClass) {
            try {
                Class<?> VMClass = Class.forName("ddtrot.com.ibm.oti.vm.VM");
                String[] argArray = (String[])VMClass.getMethod("getVMArgs", new Class[0]).invoke(null, new Object[0]);
                return Arrays.asList(argArray);
            }
            catch (ReflectiveOperationException VMClass) {
                try {
                    return ManagementFactory.getRuntimeMXBean().getInputArguments();
                }
                catch (Throwable t) {
                    System.err.println("WARNING: Unable to get VM args using managed beans");
                    return Collections.emptyList();
                }
            }
        }
    }

    private static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux");
    }
}

