/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.api.java.lang;

import datadog.trace.api.Config;
import ddtrot.dd.appsec.api.blocking.BlockingException;
import ddtrot.dd.trace.api.gateway.BlockResponseFunction;
import ddtrot.dd.trace.api.gateway.Events;
import ddtrot.dd.trace.api.gateway.Flow;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.bootstrap.ActiveSubsystems;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessImplInstrumentationHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessImplInstrumentationHelpers.class);
    private static final int LIMIT = 4096;
    public static final boolean ONLINE;
    private static final MethodHandle PROCESS_ON_EXIT;
    private static final Executor EXECUTOR;
    private static final Pattern REDACTED_PARAM_PAT;
    private static final Set<String> REDACTED_BINARIES;
    private static final ThreadLocal<Boolean> checkShi;

    private ProcessImplInstrumentationHelpers() {
    }

    public static void setTags(AgentSpan span, String[] origCommand) {
        String[] command = !ActiveSubsystems.APPSEC_ACTIVE ? new String[]{origCommand[0]} : origCommand;
        command = ProcessImplInstrumentationHelpers.redact(command);
        StringBuilder sb = new StringBuilder("[");
        long remaining = 4096L;
        for (int i = 0; i < command.length; ++i) {
            String cur = command[i];
            if ((remaining -= (long)cur.length()) < 0L) {
                span.setTag("cmd.truncated", "true");
                break;
            }
            if (i != 0) {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(cur.replace("\\", "\\\\").replace("\"", "\\\""));
            sb.append('\"');
        }
        sb.append(']');
        span.setTag("cmd.exec", sb.toString());
    }

    private static String[] redact(String[] command) {
        if (command.length == 0) {
            return command;
        }
        String[] newCommand = null;
        if (REDACTED_BINARIES.contains(ProcessImplInstrumentationHelpers.determineResource(command))) {
            newCommand = new String[command.length];
            newCommand[0] = command[0];
            for (int i = 1; i < command.length; ++i) {
                newCommand[i] = "?";
            }
            return newCommand;
        }
        boolean redactNext = false;
        for (int i = 1; i < command.length; ++i) {
            if (redactNext) {
                if (newCommand == null) {
                    newCommand = new String[command.length];
                    System.arraycopy(command, 0, newCommand, 0, command.length);
                }
                newCommand[i] = "?";
                redactNext = false;
                continue;
            }
            String s = command[i];
            if (s == null) continue;
            int posEqual = s.indexOf(61);
            if (posEqual == -1) {
                if (!REDACTED_PARAM_PAT.matcher(s).matches()) continue;
                redactNext = true;
                continue;
            }
            String param = s.substring(0, posEqual);
            if (!REDACTED_PARAM_PAT.matcher(param).matches()) continue;
            if (newCommand == null) {
                newCommand = new String[command.length];
                System.arraycopy(command, 0, newCommand, 0, command.length);
            }
            newCommand[i] = param + "=?";
        }
        return newCommand != null ? newCommand : command;
    }

    public static void addProcessCompletionHook(Process p, AgentSpan span) {
        if (PROCESS_ON_EXIT != null) {
            CompletableFuture future;
            try {
                future = PROCESS_ON_EXIT.invokeExact(p);
            }
            catch (Throwable e) {
                span.finish();
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new UndeclaredThrowableException(e);
            }
            AgentScope.Continuation continuation = AgentTracer.captureActiveSpan();
            future.whenComplete((process, thr) -> {
                if (thr != null) {
                    span.addThrowable((Throwable)thr);
                } else {
                    span.setTag("cmd.exit_code", Integer.toString(process.exitValue()));
                }
                ProcessImplInstrumentationHelpers.finishSpan(continuation, span);
            });
        } else if (EXECUTOR != null) {
            AgentScope.Continuation continuation = AgentTracer.captureActiveSpan();
            EXECUTOR.execute(() -> {
                try {
                    int exitCode = p.waitFor();
                    span.setTag("cmd.exit_code", Integer.toString(exitCode));
                }
                catch (InterruptedException e) {
                    span.addThrowable(e);
                }
                finally {
                    ProcessImplInstrumentationHelpers.finishSpan(continuation, span);
                }
            });
        }
    }

    public static CharSequence determineResource(String[] command) {
        String first = command[0];
        int pos = first.lastIndexOf(47);
        if (pos == -1 || pos == first.length() - 1) {
            return first;
        }
        return first.substring(pos + 1);
    }

    public static void cmdiRaspCheck(@Nonnull String[] cmdArray) {
        if (!Config.get().isAppSecRaspEnabled()) {
            return;
        }
        if (checkShi.get().booleanValue()) {
            return;
        }
        try {
            BiFunction<RequestContext, String[], Flow<Void>> execCmdCallback = AgentTracer.get().getCallbackProvider(RequestContextSlot.APPSEC).getCallback(Events.EVENTS.execCmd());
            if (execCmdCallback == null) {
                return;
            }
            AgentSpan span = AgentTracer.get().activeSpan();
            if (span == null) {
                return;
            }
            RequestContext ctx = span.getRequestContext();
            if (ctx == null) {
                return;
            }
            Flow<Void> flow = execCmdCallback.apply(ctx, cmdArray);
            Flow.Action action = flow.getAction();
            if (action instanceof Flow.Action.RequestBlockingAction) {
                BlockResponseFunction brf = ctx.getBlockResponseFunction();
                if (brf != null) {
                    Flow.Action.RequestBlockingAction rba = (Flow.Action.RequestBlockingAction)action;
                    brf.tryCommitBlockingResponse(ctx.getTraceSegment(), rba.getStatusCode(), rba.getBlockingContentType(), rba.getExtraHeaders());
                }
                throw new BlockingException("Blocked request (for CMDI attempt)");
            }
        }
        catch (BlockingException e) {
            throw e;
        }
        catch (Throwable e) {
            LOGGER.debug("Exception during CMDI rasp callback", e);
        }
    }

    public static void resetCheckShi() {
        checkShi.set(false);
    }

    public static void shiRaspCheck(@Nonnull String cmd) {
        if (!Config.get().isAppSecRaspEnabled()) {
            return;
        }
        checkShi.set(true);
        try {
            BiFunction<RequestContext, String, Flow<Void>> shellCmdCallback = AgentTracer.get().getCallbackProvider(RequestContextSlot.APPSEC).getCallback(Events.EVENTS.shellCmd());
            if (shellCmdCallback == null) {
                return;
            }
            AgentSpan span = AgentTracer.get().activeSpan();
            if (span == null) {
                return;
            }
            RequestContext ctx = span.getRequestContext();
            if (ctx == null) {
                return;
            }
            Flow<Void> flow = shellCmdCallback.apply(ctx, cmd);
            Flow.Action action = flow.getAction();
            if (action instanceof Flow.Action.RequestBlockingAction) {
                BlockResponseFunction brf = ctx.getBlockResponseFunction();
                if (brf != null) {
                    Flow.Action.RequestBlockingAction rba = (Flow.Action.RequestBlockingAction)action;
                    brf.tryCommitBlockingResponse(ctx.getTraceSegment(), rba.getStatusCode(), rba.getBlockingContentType(), rba.getExtraHeaders());
                }
                throw new BlockingException("Blocked request (for SHI attempt)");
            }
        }
        catch (BlockingException e) {
            throw e;
        }
        catch (Throwable e) {
            LOGGER.debug("Exception during SHI rasp callback", e);
        }
    }

    private static void finishSpan(AgentScope.Continuation parentContinuation, AgentSpan span) {
        if (parentContinuation == AgentTracer.noopContinuation()) {
            span.finish();
            return;
        }
        try (AgentScope scope = parentContinuation.activate();){
            span.finish();
        }
    }

    static {
        REDACTED_PARAM_PAT = Pattern.compile("^(?i)-{0,2}(?:p(?:ass(?:w(?:or)?d)?)?|api_?key|secret|a(?:ccess|uth)_token|mysql_pwd|credentials|(?:stripe)?token)$");
        REDACTED_BINARIES = Collections.singleton("md5");
        checkShi = ThreadLocal.withInitial(() -> false);
        MethodHandle processOnExit = null;
        Executor executor = null;
        try {
            processOnExit = MethodHandles.publicLookup().findVirtual(Process.class, "onExit", MethodType.methodType(CompletableFuture.class));
        }
        catch (Throwable e) {
            try {
                Class<?> unixProcessCls = ClassLoader.getSystemClassLoader().loadClass("java.lang.UNIXProcess");
                Field f = unixProcessCls.getDeclaredField("processReaperExecutor");
                f.setAccessible(true);
                executor = (Executor)f.get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        PROCESS_ON_EXIT = processOnExit;
        EXECUTOR = executor;
        ONLINE = PROCESS_ON_EXIT != null || EXECUTOR != null;
    }
}

