/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.context;

import ddtrot.dd.context.Context;
import ddtrot.dd.context.ContextKey;
import ddtrot.dd.context.EmptyContext;
import ddtrot.dd.context.IndexedContext;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class SingletonContext
implements Context {
    final int index;
    final Object value;

    SingletonContext(int index, Object value) {
        this.index = index;
        this.value = value;
    }

    @Nullable
    public <V> V get(ContextKey<V> key) {
        Objects.requireNonNull(key, "Context key cannot be null");
        return (V)(this.index == key.index ? this.value : null);
    }

    public <V> Context with(ContextKey<V> secondKey, @Nullable V secondValue) {
        Objects.requireNonNull(secondKey, "Context key cannot be null");
        int secondIndex = secondKey.index;
        if (this.index == secondIndex) {
            return secondValue == null ? EmptyContext.INSTANCE : new SingletonContext(this.index, secondValue);
        }
        Object[] store = new Object[Math.max(this.index, secondIndex) + 1];
        store[this.index] = this.value;
        store[secondIndex] = secondValue;
        return new IndexedContext(store);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingletonContext that = (SingletonContext)o;
        return this.index == that.index && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        int result = 31;
        result = 31 * result + this.index;
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    public String toString() {
        return "SingletonContext{index=" + this.index + ", value=" + this.value + '}';
    }
}

