/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.rum;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.api.rum.RumInjectorConfig;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class RumInjector {
    private static final RumInjector INSTANCE = new RumInjector(Config.get());
    private static final String MARKER = "</head>";
    private static final Function<String, byte[]> MARKER_BYTES = charset -> {
        try {
            return MARKER.getBytes((String)charset);
        }
        catch (Throwable t) {
            return null;
        }
    };
    private final boolean enabled;
    private final String snippet;
    private final DDCache<String, byte[]> snippetCache;
    private final DDCache<String, byte[]> markerCache;
    private final Function<String, byte[]> snippetBytes;

    RumInjector(Config config) {
        boolean rumEnabled = config.isRumEnabled();
        RumInjectorConfig injectorConfig = config.getRumInjectorConfig();
        if (rumEnabled && injectorConfig != null) {
            this.enabled = true;
            this.snippet = injectorConfig.getSnippet();
            this.snippetCache = DDCaches.newFixedSizeCache(16);
            this.markerCache = DDCaches.newFixedSizeCache(16);
            this.snippetBytes = charset -> {
                try {
                    return this.snippet.getBytes((String)charset);
                }
                catch (Throwable t) {
                    return null;
                }
            };
        } else {
            this.enabled = false;
            this.snippet = null;
            this.snippetCache = null;
            this.markerCache = null;
            this.snippetBytes = null;
        }
    }

    public static RumInjector get() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public byte[] getSnippet(String encoding) {
        if (!this.enabled) {
            return null;
        }
        return this.snippetCache.computeIfAbsent(encoding, this.snippetBytes);
    }

    @Nullable
    public byte[] getMarker(String encoding) {
        if (!this.enabled) {
            return null;
        }
        return this.markerCache.computeIfAbsent(encoding, MARKER_BYTES);
    }
}

