/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import ddtrot.dd.context.Context;
import ddtrot.dd.context.propagation.CarrierSetter;
import ddtrot.dd.context.propagation.CarrierVisitor;
import ddtrot.dd.context.propagation.Propagator;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TracingPropagator
implements Propagator {
    private final boolean enabled;
    private final HttpCodec.Injector injector;
    private final HttpCodec.Extractor extractor;

    public TracingPropagator(boolean enabled, HttpCodec.Injector injector, HttpCodec.Extractor extractor) {
        this.enabled = enabled;
        this.injector = injector;
        this.extractor = extractor;
    }

    @Override
    public <C> void inject(Context context, C carrier, CarrierSetter<C> setter) {
        AgentSpan span;
        if (context == null || carrier == null || setter == null || (span = AgentSpan.fromContext(context)) == null) {
            return;
        }
        AgentSpanContext spanContext = span.context();
        if (spanContext instanceof DDSpanContext) {
            DDSpanContext ddSpanContext = (DDSpanContext)spanContext;
            if (!this.enabled && ddSpanContext.getPropagationTags().getTraceSource() == 0) {
                return;
            }
            ddSpanContext.getTraceCollector().setSamplingPriorityIfNecessary();
            this.injector.inject(ddSpanContext, carrier, setter);
        }
    }

    @Override
    public <C> Context extract(Context context, C carrier, CarrierVisitor<C> visitor) {
        if (context == null || carrier == null || visitor == null) {
            return context;
        }
        TagContext spanContext = this.extractor.extract(carrier, TracingPropagator.toContextVisitor(visitor));
        if (spanContext == null) {
            return context;
        }
        return context.with(AgentSpan.fromSpanContext(spanContext));
    }

    private static <C> AgentPropagation.ContextVisitor<C> toContextVisitor(CarrierVisitor<C> visitor) {
        if (visitor instanceof AgentPropagation.ContextVisitor) {
            return (AgentPropagation.ContextVisitor)visitor;
        }
        return (carrier, classifier) -> visitor.forEachKeyValue(carrier, classifier::accept);
    }
}

