/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.baggage;

import datadog.trace.api.Config;
import ddtrot.dd.context.Context;
import ddtrot.dd.context.propagation.CarrierSetter;
import ddtrot.dd.context.propagation.CarrierVisitor;
import ddtrot.dd.context.propagation.Propagator;
import ddtrot.dd.trace.bootstrap.instrumentation.api.Baggage;
import ddtrot.dd.trace.core.util.PercentEscaper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class BaggagePropagator
implements Propagator {
    private static final Logger LOG = LoggerFactory.getLogger(BaggagePropagator.class);
    private static final PercentEscaper UTF_ESCAPER = PercentEscaper.create();
    static final String BAGGAGE_KEY = "baggage";
    private final boolean injectBaggage;
    private final boolean extractBaggage;
    private final int maxItems;
    private final int maxBytes;

    public BaggagePropagator(Config config) {
        this(config.isBaggageInject(), config.isBaggageExtract(), config.getTraceBaggageMaxItems(), config.getTraceBaggageMaxBytes());
    }

    BaggagePropagator(boolean injectBaggage, boolean extractBaggage, int maxItems, int maxBytes) {
        this.injectBaggage = injectBaggage;
        this.extractBaggage = extractBaggage;
        this.maxItems = maxItems;
        this.maxBytes = maxBytes;
    }

    @Override
    public <C> void inject(Context context, C carrier, CarrierSetter<C> setter) {
        Baggage baggage;
        if (!this.injectBaggage || this.maxItems == 0 || this.maxBytes == 0 || context == null || carrier == null || setter == null || (baggage = Baggage.fromContext(context)) == null) {
            return;
        }
        String headerValue = baggage.getW3cHeader();
        if (headerValue != null) {
            setter.set(carrier, BAGGAGE_KEY, headerValue);
            return;
        }
        int processedItems = 0;
        int currentBytes = 0;
        StringBuilder baggageText = new StringBuilder();
        for (Map.Entry<String, String> entry : baggage.asMap().entrySet()) {
            int extraBytes = 1;
            if (processedItems != 0) {
                baggageText.append(',');
                ++extraBytes;
            }
            PercentEscaper.Escaped escapedKey = UTF_ESCAPER.escapeKey(entry.getKey());
            PercentEscaper.Escaped escapedVal = UTF_ESCAPER.escapeValue(entry.getValue());
            baggageText.append(escapedKey.data);
            baggageText.append('=');
            baggageText.append(escapedVal.data);
            if (++processedItems == this.maxItems) break;
            if (currentBytes + escapedKey.size + escapedVal.size + extraBytes > this.maxBytes) {
                baggageText.setLength(currentBytes);
                break;
            }
            currentBytes += escapedKey.size + escapedVal.size + extraBytes;
        }
        headerValue = baggageText.toString();
        baggage.setW3cHeader(headerValue);
        setter.set(carrier, BAGGAGE_KEY, headerValue);
    }

    @Override
    public <C> Context extract(Context context, C carrier, CarrierVisitor<C> visitor) {
        if (!this.extractBaggage || context == null || carrier == null || visitor == null) {
            return context;
        }
        BaggageExtractor baggageExtractor = new BaggageExtractor();
        visitor.forEachKeyValue(carrier, baggageExtractor);
        return baggageExtractor.extracted == null ? context : context.with(baggageExtractor.extracted);
    }

    private class BaggageExtractor
    implements BiConsumer<String, String> {
        private static final char KEY_VALUE_SEPARATOR = '=';
        private static final char PAIR_SEPARATOR = ',';
        private Baggage extracted;
        private String w3cHeader;

        private BaggageExtractor() {
        }

        private String decode(String value) {
            String decoded = value;
            try {
                decoded = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                LOG.debug("Failed to decode {}", (Object)value);
            }
            return decoded;
        }

        private Map<String, String> parseBaggageHeaders(String input) {
            HashMap<String, String> baggage = new HashMap<String, String>();
            int start = 0;
            boolean truncatedCache = false;
            int pairSeparatorInd = input.indexOf(44);
            pairSeparatorInd = pairSeparatorInd == -1 ? input.length() : pairSeparatorInd;
            int kvSeparatorInd = input.indexOf(61);
            while (kvSeparatorInd != -1) {
                int end = pairSeparatorInd;
                if (kvSeparatorInd > end) {
                    LOG.debug("Dropping baggage headers due to key with no value {}", (Object)input.substring(start, end));
                    return Collections.emptyMap();
                }
                String key = this.decode(input.substring(start, kvSeparatorInd).trim());
                String value = this.decode(input.substring(kvSeparatorInd + 1, end).trim());
                if (key.isEmpty() || value.isEmpty()) {
                    LOG.debug("Dropping baggage headers due to empty k/v {}:{}", (Object)key, (Object)value);
                    return Collections.emptyMap();
                }
                baggage.put(key, value);
                if (UTF_ESCAPER.keyNeedsEncoding(key) || UTF_ESCAPER.valNeedsEncoding(value)) {
                    truncatedCache = true;
                    this.w3cHeader = null;
                } else if (!(truncatedCache || end <= BaggagePropagator.this.maxBytes && baggage.size() <= BaggagePropagator.this.maxItems)) {
                    this.w3cHeader = start == 0 ? null : input.substring(0, start - 1);
                    truncatedCache = true;
                }
                kvSeparatorInd = input.indexOf(61, pairSeparatorInd + 1);
                pairSeparatorInd = input.indexOf(44, pairSeparatorInd + 1);
                pairSeparatorInd = pairSeparatorInd == -1 ? input.length() : pairSeparatorInd;
                start = end + 1;
            }
            if (!truncatedCache) {
                this.w3cHeader = input;
            }
            return baggage;
        }

        @Override
        public void accept(String key, String value) {
            Map<String, String> baggage;
            if (BaggagePropagator.BAGGAGE_KEY.equalsIgnoreCase(key) && !(baggage = this.parseBaggageHeaders(value)).isEmpty()) {
                this.extracted = Baggage.create(baggage, this.w3cHeader);
            }
        }
    }
}

