/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.taginterceptor;

import datadog.trace.api.Config;
import datadog.trace.api.Pair;
import ddtrot.dd.trace.api.env.CapturedEnvironment;
import ddtrot.dd.trace.api.normalize.HttpResourceNames;
import ddtrot.dd.trace.api.remoteconfig.ServiceNameCollector;
import ddtrot.dd.trace.bootstrap.instrumentation.api.URIUtils;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.taginterceptor.RuleFlags;
import java.net.URI;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TagInterceptor {
    private static final UTF8BytesString NOT_FOUND_RESOURCE_NAME = UTF8BytesString.create("404");
    private final RuleFlags ruleFlags;
    private final boolean isServiceNameSetByUser;
    private final boolean splitByServletContext;
    private final String inferredServiceName;
    private final Set<String> splitServiceTags;
    private final boolean shouldSet404ResourceName;
    private final boolean shouldSetUrlResourceAsName;
    private final boolean jeeSplitByDeployment;

    public TagInterceptor(RuleFlags ruleFlags) {
        this(Config.get().isServiceNameSetByUser(), CapturedEnvironment.get().getProperties().get("service.name"), Config.get().getSplitByTags(), ruleFlags, Config.get().isJeeSplitByDeployment());
    }

    public TagInterceptor(boolean isServiceNameSetByUser, String inferredServiceName, Set<String> splitServiceTags, RuleFlags ruleFlags, boolean jeeSplitByDeployment) {
        this.isServiceNameSetByUser = isServiceNameSetByUser;
        this.inferredServiceName = inferredServiceName;
        this.splitServiceTags = splitServiceTags;
        this.ruleFlags = ruleFlags;
        this.splitByServletContext = splitServiceTags.contains("servlet.context");
        this.shouldSet404ResourceName = ruleFlags.isEnabled(RuleFlags.Feature.URL_AS_RESOURCE_NAME) && ruleFlags.isEnabled(RuleFlags.Feature.STATUS_404) && ruleFlags.isEnabled(RuleFlags.Feature.STATUS_404_DECORATOR);
        this.shouldSetUrlResourceAsName = ruleFlags.isEnabled(RuleFlags.Feature.URL_AS_RESOURCE_NAME);
        this.jeeSplitByDeployment = jeeSplitByDeployment;
    }

    public boolean interceptTag(DDSpanContext span, String tag, Object value) {
        switch (tag) {
            case "resource.name": {
                return this.interceptResourceName(span, value);
            }
            case "db.statement": {
                return this.interceptDbStatement(span, value);
            }
            case "service.name": 
            case "service": {
                return this.interceptServiceName(RuleFlags.Feature.SERVICE_NAME, span, value);
            }
            case "peer.service": {
                span.setTag("_dd.peer.service.source", "peer.service");
                return this.interceptServiceName(RuleFlags.Feature.PEER_SERVICE, span, value);
            }
            case "manual.keep": {
                if (TagInterceptor.asBoolean(value)) {
                    span.forceKeep();
                    return true;
                }
                return false;
            }
            case "manual.drop": {
                return this.interceptSamplingPriority(RuleFlags.Feature.FORCE_MANUAL_DROP, -1, 4, span, value);
            }
            case "asm.keep": {
                if (TagInterceptor.asBoolean(value)) {
                    span.forceKeep((byte)5);
                    return true;
                }
                return false;
            }
            case "sampling.priority": {
                return this.interceptSamplingPriority(span, value);
            }
            case "_dd.p.ts": {
                if (value instanceof Integer) {
                    span.addPropagatedTraceSource((Integer)value);
                    return true;
                }
                return false;
            }
            case "_dd.p.debug": {
                span.updateDebugPropagation(String.valueOf(value));
                return true;
            }
            case "servlet.context": {
                return this.interceptServletContext(span, value);
            }
            case "span.type": {
                return this.interceptSpanType(span, value);
            }
            case "_dd1.sr.eausr": {
                return this.interceptAnalyticsSampleRate(span, value);
            }
            case "error": {
                return this.interceptError(span, value);
            }
            case "http.status_code": {
                return this.interceptHttpStatusCode(span, value);
            }
            case "http.method": 
            case "http.url": {
                return this.interceptUrlResourceAsNameRule(span, tag, value);
            }
            case "_dd.origin": {
                return this.interceptOrigin(span, value);
            }
            case "_dd.measured": {
                return TagInterceptor.interceptMeasured(span, value);
            }
        }
        return this.intercept(span, tag, value);
    }

    private boolean interceptUrlResourceAsNameRule(DDSpanContext span, String tag, Object value) {
        if (this.shouldSetUrlResourceAsName) {
            if ("http.method".equals(tag)) {
                Object url = span.unsafeGetTag("http.url");
                if (url != null) {
                    TagInterceptor.setResourceFromUrl(span, value.toString(), url);
                }
            } else if ("http.url".equals(tag)) {
                Object method = span.unsafeGetTag("http.method");
                TagInterceptor.setResourceFromUrl(span, method != null ? method.toString() : null, value);
            }
        }
        return false;
    }

    private static void setResourceFromUrl(@Nonnull DDSpanContext span, @Nullable String method, @Nonnull Object url) {
        String path;
        if (url instanceof URIUtils.LazyUrl) {
            path = ((URIUtils.LazyUrl)url).path();
        } else {
            URI uri = URIUtils.safeParse(url.toString());
            String string = path = uri == null ? null : uri.getPath();
        }
        if (path != null) {
            Pair<CharSequence, Byte> normalized;
            boolean isClient = "client".equals(span.unsafeGetTag("span.kind"));
            Pair<CharSequence, Byte> pair = normalized = isClient ? HttpResourceNames.computeForClient(method, path, false) : HttpResourceNames.computeForServer(method, path, false);
            if (normalized.hasLeft()) {
                span.setResourceName(normalized.getLeft(), normalized.getRight());
            }
        } else {
            span.setResourceName(HttpResourceNames.DEFAULT_RESOURCE_NAME, (byte)1);
        }
    }

    private boolean intercept(DDSpanContext span, String tag, Object value) {
        if (this.splitServiceTags.contains(tag)) {
            span.setServiceName(String.valueOf(value));
            return true;
        }
        return false;
    }

    private boolean interceptResourceName(DDSpanContext span, Object value) {
        if (this.ruleFlags.isEnabled(RuleFlags.Feature.RESOURCE_NAME)) {
            if (null == value) {
                return false;
            }
            if (value instanceof CharSequence) {
                span.setResourceName((CharSequence)value, (byte)5);
            } else {
                span.setResourceName(String.valueOf(value), (byte)5);
            }
            return true;
        }
        return false;
    }

    private boolean interceptDbStatement(DDSpanContext span, Object value) {
        CharSequence resourceName;
        if (value instanceof CharSequence && (resourceName = (CharSequence)value).length() > 0) {
            span.setResourceName(resourceName, (byte)5);
        }
        return true;
    }

    private boolean interceptError(DDSpanContext span, Object value) {
        span.setErrorFlag(TagInterceptor.asBoolean(value), (byte)0);
        return true;
    }

    private boolean interceptAnalyticsSampleRate(DDSpanContext span, Object value) {
        Number analyticsSampleRate = TagInterceptor.getOrTryParse(value);
        if (null != analyticsSampleRate) {
            span.setMetric("_dd1.sr.eausr", analyticsSampleRate);
        }
        return true;
    }

    private boolean interceptSpanType(DDSpanContext span, Object value) {
        if (value instanceof CharSequence) {
            span.setSpanType((CharSequence)value);
        } else {
            span.setSpanType(String.valueOf(value));
        }
        return true;
    }

    private boolean interceptServiceName(RuleFlags.Feature feature, DDSpanContext span, Object value) {
        if (this.ruleFlags.isEnabled(feature)) {
            String serviceName = String.valueOf(value);
            span.setServiceName(serviceName);
            ServiceNameCollector.get().addService(serviceName);
            return true;
        }
        return false;
    }

    private boolean interceptSamplingPriority(RuleFlags.Feature feature, int samplingPriority, int samplingMechanism, DDSpanContext span, Object value) {
        if (this.ruleFlags.isEnabled(feature)) {
            if (TagInterceptor.asBoolean(value)) {
                span.setSamplingPriority(samplingPriority, samplingMechanism);
            }
            return true;
        }
        return false;
    }

    private boolean interceptSamplingPriority(DDSpanContext span, Object value) {
        if (this.ruleFlags.isEnabled(RuleFlags.Feature.FORCE_SAMPLING_PRIORITY)) {
            Number samplingPriority = TagInterceptor.getOrTryParse(value);
            if (null != samplingPriority) {
                span.setSamplingPriority(samplingPriority.intValue() > 0 ? 2 : -1, 4);
            }
            return true;
        }
        return false;
    }

    private boolean interceptServletContext(DDSpanContext span, Object value) {
        if (!(this.splitByServletContext || !this.isServiceNameSetByUser && !this.jeeSplitByDeployment && this.ruleFlags.isEnabled(RuleFlags.Feature.SERVLET_CONTEXT) && (span.getServiceName().isEmpty() || span.getServiceName().equals(this.inferredServiceName) || span.getServiceName().equals("unnamed-java-app")))) {
            return false;
        }
        String contextName = String.valueOf(value).trim();
        if (!contextName.isEmpty()) {
            String serviceName = null;
            if (contextName.equals("/")) {
                serviceName = Config.get().getRootContextServiceName();
                span.setServiceName(serviceName);
            } else if (contextName.charAt(0) == '/') {
                if (contextName.length() > 1) {
                    serviceName = contextName.substring(1);
                    span.setServiceName(serviceName);
                }
            } else {
                serviceName = contextName;
                span.setServiceName(serviceName);
            }
            ServiceNameCollector.get().addService(serviceName);
        }
        return false;
    }

    private boolean interceptHttpStatusCode(DDSpanContext span, Object statusCode) {
        if (statusCode instanceof Number) {
            span.setHttpStatusCode(((Number)statusCode).shortValue());
            if (this.shouldSet404ResourceName && span.getHttpStatusCode() == 404) {
                span.setResourceName(NOT_FOUND_RESOURCE_NAME, (byte)2);
            }
            return true;
        }
        try {
            span.setHttpStatusCode(Short.parseShort(String.valueOf(statusCode)));
            if (this.shouldSet404ResourceName && span.getHttpStatusCode() == 404) {
                span.setResourceName(NOT_FOUND_RESOURCE_NAME, (byte)2);
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean interceptOrigin(DDSpanContext span, Object origin) {
        if (origin instanceof CharSequence) {
            span.setOrigin((CharSequence)origin);
        } else {
            span.setOrigin(String.valueOf(origin));
        }
        return true;
    }

    private static boolean interceptMeasured(DDSpanContext span, Object value) {
        if (value instanceof Number && ((Number)value).intValue() > 0 || TagInterceptor.asBoolean(value)) {
            span.setMeasured(true);
            return true;
        }
        return false;
    }

    private static boolean asBoolean(Object value) {
        return Boolean.TRUE.equals(value) || "1".equals(value) || !Boolean.FALSE.equals(value) && Boolean.parseBoolean(String.valueOf(value));
    }

    private static Number getOrTryParse(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

