/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

import ddtrot.dd.environment.JavaVirtualMachine;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProcessUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);

    @Nullable
    @SuppressForbidden
    public static String getCurrentJvmPath() {
        if (JavaVirtualMachine.isJavaVersionAtLeast(9)) {
            try {
                Supplier jdk9Supplier = (Supplier)Class.forName("ddtrot.dd.trace.util.JDK9ExecutableSupplier").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return (String)jdk9Supplier.get();
            }
            catch (Throwable e) {
                log.debug("Could not get process executable path using JDK9ExecutableSupplier", e);
            }
        }
        return System.getProperty("java.home");
    }

    private ProcessUtils() {
    }
}

