/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

public enum UserEventTrackingMode {
    DISABLED("disabled"),
    SAFE("safe", "true", "1"),
    EXTENDED("extended");

    private final String value;
    private final String[] modes;

    private UserEventTrackingMode(String ... modes) {
        this.value = modes[0];
        this.modes = modes;
    }

    private boolean matches(String mode) {
        for (String value : this.modes) {
            if (!value.equalsIgnoreCase(mode)) continue;
            return true;
        }
        return false;
    }

    public static UserEventTrackingMode fromString(String s) {
        if (SAFE.matches(s)) {
            return SAFE;
        }
        if (EXTENDED.matches(s)) {
            return EXTENDED;
        }
        return DISABLED;
    }

    public String toString() {
        return this.value;
    }
}

