/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.environment;

import ddtrot.dd.environment.CommandLine;
import ddtrot.dd.environment.JavaVersion;
import ddtrot.dd.environment.JvmOptions;
import ddtrot.dd.environment.SystemProperties;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public final class JavaVirtualMachine {
    private static final CommandLine commandLine = new CommandLine();
    private static final JavaVersion javaVersion = JavaVersion.getRuntimeVersion();
    private static final Runtime runtime = new Runtime();

    private JavaVirtualMachine() {
    }

    public static boolean isJavaVersion(int major) {
        return javaVersion.is(major);
    }

    public static boolean isJavaVersion(int major, int minor) {
        return javaVersion.is(major, minor);
    }

    public static boolean isJavaVersion(int major, int minor, int update) {
        return javaVersion.is(major, minor, update);
    }

    public static boolean isJavaVersionAtLeast(int major) {
        return JavaVirtualMachine.isJavaVersionAtLeast(major, 0, 0);
    }

    public static boolean isJavaVersionAtLeast(int major, int minor) {
        return JavaVirtualMachine.isJavaVersionAtLeast(major, minor, 0);
    }

    public static boolean isJavaVersionAtLeast(int major, int minor, int update) {
        return javaVersion.isAtLeast(major, minor, update);
    }

    public static boolean isJavaVersionBetween(int fromMajor, int toMajor) {
        return JavaVirtualMachine.isJavaVersionBetween(fromMajor, 0, toMajor, 0);
    }

    public static boolean isJavaVersionBetween(int fromMajor, int fromMinor, int toMajor, int toMinor) {
        return JavaVirtualMachine.isJavaVersionBetween(fromMajor, fromMinor, 0, toMajor, toMinor, 0);
    }

    public static boolean isJavaVersionBetween(int fromMajor, int fromMinor, int fromUpdate, int toMajor, int toMinor, int toUpdate) {
        return javaVersion.isBetween(fromMajor, fromMinor, fromUpdate, toMajor, toMinor, toUpdate);
    }

    public static boolean isOracleJDK8() {
        return JavaVirtualMachine.isJavaVersion(8) && JavaVirtualMachine.runtime.vendor.contains("Oracle") && !JavaVirtualMachine.runtime.name.contains("OpenJDK");
    }

    public static boolean isJ9() {
        return SystemProperties.getOrDefault("java.vm.name", "").contains("J9");
    }

    public static boolean isIbm8() {
        return JavaVirtualMachine.isJavaVersion(8) && JavaVirtualMachine.runtime.vendor.contains("IBM");
    }

    public static boolean isGraalVM() {
        return JavaVirtualMachine.runtime.vendorVersion.toLowerCase().contains("graalvm");
    }

    public static String getLangVersion() {
        return String.valueOf(JavaVirtualMachine.javaVersion.major);
    }

    public static String getRuntimeVendor() {
        return JavaVirtualMachine.runtime.vendor;
    }

    public static String getRuntimeVersion() {
        return JavaVirtualMachine.runtime.version;
    }

    public static String getRuntimePatches() {
        return JavaVirtualMachine.runtime.patches;
    }

    public static List<String> getVmOptions() {
        return JvmOptionsHolder.JVM_OPTIONS.VM_OPTIONS;
    }

    public static List<String> getCommandArguments() {
        return JavaVirtualMachine.commandLine.arguments;
    }

    @Nullable
    public static String getMainClass() {
        return JavaVirtualMachine.commandLine.name != null && !JavaVirtualMachine.isJarName(JavaVirtualMachine.commandLine.name) ? JavaVirtualMachine.commandLine.name : null;
    }

    @Nullable
    public static String getJarFile() {
        return JavaVirtualMachine.commandLine.name != null && JavaVirtualMachine.isJarName(JavaVirtualMachine.commandLine.name) ? JavaVirtualMachine.commandLine.name : null;
    }

    private static boolean isJarName(String argument) {
        return argument.toLowerCase(Locale.ROOT).endsWith(".jar");
    }

    static final class Runtime {
        public final String name;
        public final String vendor;
        public final String version;
        public final String vendorVersion;
        public final String patches;

        public Runtime() {
            this(SystemProperties.get("java.version"), SystemProperties.get("java.runtime.version"), SystemProperties.get("java.runtime.name"), SystemProperties.get("java.vm.vendor"), SystemProperties.get("java.vendor.version"));
        }

        Runtime(String javaVer, String rtVer, String name, String vendor, String vendorVersion) {
            this.name = name == null ? "" : name;
            this.vendor = vendor == null ? "" : vendor;
            this.version = javaVer = javaVer == null ? "" : javaVer;
            this.vendorVersion = vendorVersion == null ? "" : vendorVersion;
            rtVer = javaVer.isEmpty() || rtVer == null ? javaVer : rtVer;
            int patchStart = javaVer.length() + 1;
            this.patches = patchStart >= rtVer.length() ? "" : rtVer.substring(javaVer.length() + 1);
        }
    }

    private static class JvmOptionsHolder {
        private static final JvmOptions JVM_OPTIONS = new JvmOptions();

        private JvmOptionsHolder() {
        }
    }
}

