/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.Config;
import datadog.trace.api.DynamicConfig;
import datadog.trace.api.sampling.SamplingRule;
import ddtrot.com.squareup.moshi.FromJson;
import ddtrot.com.squareup.moshi.Json;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.JsonReader;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.ToJson;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.remoteconfig.ConfigurationPoller;
import ddtrot.dd.remoteconfig.PollingRateHinter;
import ddtrot.dd.remoteconfig.Product;
import ddtrot.dd.remoteconfig.state.ConfigKey;
import ddtrot.dd.remoteconfig.state.ProductListener;
import ddtrot.dd.trace.bootstrap.debugger.DebuggerContext;
import ddtrot.dd.trace.logging.GlobalLogLevelSwitcher;
import ddtrot.dd.trace.logging.LogLevel;
import ddtrot.okio.BufferedSource;
import ddtrot.okio.Okio;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TracingConfigPoller {
    static final Logger log = LoggerFactory.getLogger(TracingConfigPoller.class);
    private final DynamicConfig<?> dynamicConfig;
    private boolean startupLogsEnabled;
    private Runnable stopPolling;

    public TracingConfigPoller(DynamicConfig<?> dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
    }

    public void start(Config config, SharedCommunicationObjects sco) {
        this.startupLogsEnabled = config.isStartupLogsEnabled();
        ConfigurationPoller configPoller = sco.configurationPoller(config);
        if (configPoller != null) {
            configPoller.addCapabilities(4123707109376L);
        }
        this.stopPolling = new Updater().register(config, configPoller);
    }

    public void stop() {
        if (null != this.stopPolling) {
            this.stopPolling.run();
        }
    }

    void applyConfigOverrides(LibConfig libConfig) {
        DynamicConfig.Builder builder = this.dynamicConfig.initial();
        if (libConfig.debugEnabled != null) {
            if (Boolean.TRUE.equals(libConfig.debugEnabled)) {
                GlobalLogLevelSwitcher.get().switchLevel(LogLevel.DEBUG);
            } else if (this.startupLogsEnabled) {
                GlobalLogLevelSwitcher.get().switchLevel(LogLevel.INFO);
            } else {
                GlobalLogLevelSwitcher.get().switchLevel(LogLevel.WARN);
            }
        } else {
            GlobalLogLevelSwitcher.get().restore();
        }
        this.maybeOverride(builder::setTracingEnabled, libConfig.tracingEnabled);
        this.maybeOverride(builder::setRuntimeMetricsEnabled, libConfig.runtimeMetricsEnabled);
        this.maybeOverride(builder::setLogsInjectionEnabled, libConfig.logsInjectionEnabled);
        this.maybeOverride(builder::setDataStreamsEnabled, libConfig.dataStreamsEnabled);
        this.maybeOverride(builder::setServiceMapping, libConfig.serviceMapping);
        this.maybeOverride(builder::setHeaderTags, libConfig.headerTags);
        if (null != libConfig.tracingSamplingRules) {
            builder.setTraceSamplingRules(libConfig.tracingSamplingRules.data, libConfig.tracingSamplingRules.json);
        }
        this.maybeOverride(builder::setTraceSampleRate, libConfig.traceSampleRate);
        this.maybeOverride(builder::setTracingTags, this.parseTagListToMap(libConfig.tracingTags));
        DebuggerContext.updateConfig(libConfig.dynamicInstrumentationEnabled, libConfig.exceptionReplayEnabled, libConfig.codeOriginEnabled, libConfig.liveDebuggingEnabled);
        builder.apply();
    }

    void removeConfigOverrides() {
        this.dynamicConfig.resetTraceConfig();
        GlobalLogLevelSwitcher.get().restore();
    }

    private <T> void maybeOverride(Consumer<T> setter, T override) {
        if (null != override) {
            setter.accept(override);
        }
    }

    private Map<String, String> parseTagListToMap(List<String> input) {
        if (null == input) {
            return null;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(input.size());
        for (String s : input) {
            int colonIndex = s.indexOf(":");
            if (colonIndex <= -1 || colonIndex >= s.length() - 1) continue;
            String key = s.substring(0, colonIndex);
            String value = s.substring(colonIndex + 1);
            if (key.isEmpty() || value.isEmpty()) continue;
            resultMap.put(key, value);
        }
        return resultMap;
    }

    static final class SamplingRuleTagEntry
    implements Map.Entry<String, String> {
        @Json(name="key")
        public String key;
        @Json(name="value_glob")
        public String value;

        SamplingRuleTagEntry() {
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class TracingSamplingRule
    implements SamplingRule.TraceSamplingRule {
        @Json(name="service")
        public String service;
        @Json(name="name")
        public String name;
        @Json(name="resource")
        public String resource;
        @Json(name="tags")
        public List<SamplingRuleTagEntry> tags;
        @Json(name="sample_rate")
        public Double sampleRate;
        @Json(name="provenance")
        public String provenance;
        private transient Map<String, String> tagMap;

        TracingSamplingRule() {
        }

        @Override
        public String getService() {
            return this.service;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getResource() {
            return this.resource;
        }

        @Override
        public Map<String, String> getTags() {
            if (null == this.tagMap) {
                this.tagMap = null == this.tags ? Collections.emptyMap() : this.tags.stream().collect(Collectors.toMap(SamplingRuleTagEntry::getKey, e -> SamplingRule.normalizeGlob(e.getValue())));
            }
            return this.tagMap;
        }

        @Override
        public double getSampleRate() {
            return this.sampleRate;
        }

        @Override
        public SamplingRule.Provenance getProvenance() {
            if ("dynamic".equals(this.provenance)) {
                return SamplingRule.Provenance.DYNAMIC;
            }
            return SamplingRule.Provenance.CUSTOMER;
        }
    }

    static final class HeaderTagEntry
    implements Map.Entry<String, String> {
        @Json(name="header")
        public String header;
        @Json(name="tag_name")
        public String tagName;

        HeaderTagEntry() {
        }

        @Override
        public String getKey() {
            return this.header;
        }

        @Override
        public String getValue() {
            return this.tagName;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class ServiceMappingEntry
    implements Map.Entry<String, String> {
        @Json(name="from_key")
        public String fromKey;
        @Json(name="to_name")
        public String toName;

        ServiceMappingEntry() {
        }

        @Override
        public String getKey() {
            return this.fromKey;
        }

        @Override
        public String getValue() {
            return this.toName;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class TracingSamplingRulesAdapter {
        TracingSamplingRulesAdapter() {
        }

        @FromJson
        TracingSamplingRules fromJson(JsonReader reader, JsonAdapter<List<TracingSamplingRule>> parser) throws IOException {
            if (reader.peek() == JsonReader.Token.NULL) {
                return (TracingSamplingRules)reader.nextNull();
            }
            try (BufferedSource source = reader.nextSource();){
                String json = source.readUtf8();
                TracingSamplingRules tracingSamplingRules = new TracingSamplingRules(json, parser.fromJson(json));
                return tracingSamplingRules;
            }
        }

        @ToJson
        String toJson(TracingSamplingRules rules) {
            return rules.json;
        }
    }

    static final class TracingSamplingRules {
        public final String json;
        public final List<TracingSamplingRule> data;

        TracingSamplingRules(String json, List<TracingSamplingRule> data) {
            this.json = json;
            this.data = data;
        }
    }

    static final class LibConfig {
        @Json(name="tracing_enabled")
        public Boolean tracingEnabled;
        @Json(name="tracing_debug")
        public Boolean debugEnabled;
        @Json(name="runtime_metrics_enabled")
        public Boolean runtimeMetricsEnabled;
        @Json(name="log_injection_enabled")
        public Boolean logsInjectionEnabled;
        @Json(name="data_streams_enabled")
        public Boolean dataStreamsEnabled;
        @Json(name="tracing_service_mapping")
        public List<ServiceMappingEntry> serviceMapping;
        @Json(name="tracing_header_tags")
        public List<HeaderTagEntry> headerTags;
        @Json(name="tracing_sampling_rate")
        public Double traceSampleRate;
        @Json(name="tracing_tags")
        public List<String> tracingTags;
        @Json(name="tracing_sampling_rules")
        public TracingSamplingRules tracingSamplingRules;
        @Json(name="dynamic_instrumentation_enabled")
        public Boolean dynamicInstrumentationEnabled;
        @Json(name="exception_replay_enabled")
        public Boolean exceptionReplayEnabled;
        @Json(name="code_origin_enabled")
        public Boolean codeOriginEnabled;
        @Json(name="live_debugging_enabled")
        public Boolean liveDebuggingEnabled;

        LibConfig() {
        }
    }

    static final class ConfigOverrides {
        @Json(name="lib_config")
        public LibConfig libConfig;

        ConfigOverrides() {
        }
    }

    final class Updater
    implements ProductListener {
        private final JsonAdapter<ConfigOverrides> CONFIG_OVERRIDES_ADAPTER;
        private final JsonAdapter<TracingSamplingRule> TRACE_SAMPLING_RULE;
        private boolean receivedOverrides;

        Updater() {
            Moshi MOSHI = new Moshi.Builder().add(new TracingSamplingRulesAdapter()).build();
            this.CONFIG_OVERRIDES_ADAPTER = MOSHI.adapter(ConfigOverrides.class);
            this.TRACE_SAMPLING_RULE = MOSHI.adapter(TracingSamplingRule.class);
            this.receivedOverrides = false;
        }

        public Runnable register(Config config, ConfigurationPoller poller) {
            if (null != poller) {
                poller.addListener(Product.APM_TRACING, this);
                return poller::stop;
            }
            return null;
        }

        @Override
        public void accept(ConfigKey configKey, byte[] content, PollingRateHinter hinter) throws IOException {
            ConfigOverrides overrides = this.CONFIG_OVERRIDES_ADAPTER.fromJson(Okio.buffer(Okio.source(new ByteArrayInputStream(content))));
            if (null != overrides && null != overrides.libConfig) {
                this.receivedOverrides = true;
                TracingConfigPoller.this.applyConfigOverrides(this.checkConfig(overrides.libConfig));
                if (log.isDebugEnabled()) {
                    log.debug("Applied APM_TRACING overrides: {}", (Object)this.CONFIG_OVERRIDES_ADAPTER.toJson(overrides));
                }
            } else {
                log.debug("No APM_TRACING overrides");
            }
        }

        @Override
        public void remove(ConfigKey configKey, PollingRateHinter hinter) {
        }

        @Override
        public void commit(PollingRateHinter hinter) {
            if (!this.receivedOverrides) {
                TracingConfigPoller.this.removeConfigOverrides();
                log.debug("Removed APM_TRACING overrides");
            } else {
                this.receivedOverrides = false;
            }
        }

        private LibConfig checkConfig(LibConfig libConfig) {
            libConfig.traceSampleRate = this.checkSampleRate(libConfig.traceSampleRate);
            libConfig.tracingSamplingRules = this.checkSamplingRules(libConfig.tracingSamplingRules);
            return libConfig;
        }

        private Double checkSampleRate(Double sampleRate) {
            if (null != sampleRate) {
                if (sampleRate > 1.0) {
                    log.debug("Unexpected sample rate {}, using 1.0", (Object)sampleRate);
                    return 1.0;
                }
                if (sampleRate < 0.0) {
                    log.debug("Unexpected sample rate {}, using 0.0", (Object)sampleRate);
                    return 0.0;
                }
            }
            return sampleRate;
        }

        private TracingSamplingRules checkSamplingRules(TracingSamplingRules rules) {
            if (null == rules || null == rules.data) {
                return null;
            }
            Iterator<TracingSamplingRule> itr = rules.data.iterator();
            while (itr.hasNext()) {
                TracingSamplingRule rule = itr.next();
                if (null == rule.service && null == rule.name && null == rule.resource && null == rule.tags || null == rule.sampleRate) {
                    log.debug("Invalid sampling rule from remote-config, rule will be removed: {}", (Object)this.TRACE_SAMPLING_RULE.toJson(rule));
                    itr.remove();
                }
                rule.service = SamplingRule.normalizeGlob(rule.service);
                rule.name = SamplingRule.normalizeGlob(rule.name);
                rule.resource = SamplingRule.normalizeGlob(rule.resource);
                rule.sampleRate = this.checkSampleRate(rule.sampleRate);
            }
            return rules;
        }
    }
}

