/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import datadog.trace.api.Config;
import datadog.trace.api.ProcessTags;
import datadog.trace.api.WellKnownTags;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.ByteArrayInput;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.GrowingByteArrayOutput;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.VarEncodingHelper;
import ddtrot.dd.context.propagation.CarrierVisitor;
import ddtrot.dd.trace.api.datastreams.DataStreamsContext;
import ddtrot.dd.trace.api.datastreams.PathwayContext;
import ddtrot.dd.trace.api.datastreams.StatsPoint;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import ddtrot.dd.trace.core.datastreams.TagsProcessor;
import ddtrot.dd.trace.util.FNV64Hash;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPathwayContext
implements PathwayContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultPathwayContext.class);
    private final Lock lock = new ReentrantLock();
    private final long hashOfKnownTags;
    private final TimeSource timeSource;
    private final String serviceNameOverride;
    private final GrowingByteArrayOutput outputBuffer = GrowingByteArrayOutput.withInitialCapacity(20);
    private long pathwayStartNanos;
    private long pathwayStartNanoTicks;
    private long edgeStartNanoTicks;
    private StatsPoint savedStats;
    private long hash;
    private boolean started;
    private long closestOppositeDirectionHash;
    private String previousDirection;
    private static final Set<String> hashableTagKeys = new HashSet<String>(Arrays.asList("group", "type", "direction", "topic", "exchange"));
    private static final Set<String> extraAggregationTagKeys = new HashSet<String>(Arrays.asList("ds.name", "ds.namespace", "manual_checkpoint"));

    public DefaultPathwayContext(TimeSource timeSource, long hashOfKnownTags, String serviceNameOverride) {
        this.timeSource = timeSource;
        this.hashOfKnownTags = hashOfKnownTags;
        this.serviceNameOverride = serviceNameOverride;
    }

    private DefaultPathwayContext(TimeSource timeSource, long hashOfKnownTags, long pathwayStartNanos, long pathwayStartNanoTicks, long edgeStartNanoTicks, long hash, String serviceNameOverride) {
        this(timeSource, hashOfKnownTags, serviceNameOverride);
        this.pathwayStartNanos = pathwayStartNanos;
        this.pathwayStartNanoTicks = pathwayStartNanoTicks;
        this.edgeStartNanoTicks = edgeStartNanoTicks;
        this.hash = hash;
        this.closestOppositeDirectionHash = hash;
        this.started = true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public long getHash() {
        return this.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckpoint(DataStreamsContext context, Consumer<StatsPoint> pointConsumer) {
        long startNanos = this.timeSource.getCurrentTimeNanos();
        long nanoTicks = this.timeSource.getNanoTicks();
        this.lock.lock();
        try {
            LinkedHashMap<String, String> sortedTags = context.sortedTags();
            ArrayList<String> allTags = new ArrayList<String>(sortedTags.size());
            PathwayHashBuilder pathwayHashBuilder = new PathwayHashBuilder(this.hashOfKnownTags, this.serviceNameOverride);
            DataSetHashBuilder aggregationHashBuilder = new DataSetHashBuilder();
            if (!this.started) {
                long defaultTimestamp = context.defaultTimestamp();
                if (defaultTimestamp == 0L) {
                    this.pathwayStartNanos = startNanos;
                    this.pathwayStartNanoTicks = nanoTicks;
                    this.edgeStartNanoTicks = nanoTicks;
                } else {
                    this.pathwayStartNanos = TimeUnit.MILLISECONDS.toNanos(defaultTimestamp);
                    this.edgeStartNanoTicks = this.pathwayStartNanoTicks = nanoTicks - TimeUnit.MILLISECONDS.toNanos(this.timeSource.getCurrentTimeMillis() - defaultTimestamp);
                }
                this.hash = 0L;
                this.started = true;
                log.debug("Started {}", (Object)this);
            }
            for (Map.Entry<String, String> entry : sortedTags.entrySet()) {
                String tag = TagsProcessor.createTag(entry.getKey(), entry.getValue());
                if (tag == null) continue;
                if (hashableTagKeys.contains(entry.getKey())) {
                    pathwayHashBuilder.addTag(tag);
                }
                if (extraAggregationTagKeys.contains(entry.getKey())) {
                    aggregationHashBuilder.addValue(tag);
                }
                allTags.add(tag);
            }
            long nodeHash = this.generateNodeHash(pathwayHashBuilder);
            if (sortedTags.containsKey("direction")) {
                String direction = sortedTags.get("direction");
                if (direction.equals(this.previousDirection)) {
                    this.hash = this.closestOppositeDirectionHash;
                } else {
                    this.previousDirection = direction;
                    this.closestOppositeDirectionHash = this.hash;
                }
            }
            long newHash = this.generatePathwayHash(nodeHash, this.hash);
            long aggregationHash = aggregationHashBuilder.addValue(String.valueOf(newHash));
            long pathwayLatencyNano = nanoTicks - this.pathwayStartNanoTicks;
            long edgeLatencyNano = nanoTicks - this.edgeStartNanoTicks;
            StatsPoint point = new StatsPoint(allTags, newHash, this.hash, aggregationHash, startNanos, pathwayLatencyNano, edgeLatencyNano, context.payloadSizeBytes(), this.serviceNameOverride);
            this.edgeStartNanoTicks = nanoTicks;
            this.hash = newHash;
            pointConsumer.accept(point);
            log.debug("Checkpoint set {}, hash source: {}", (Object)this, (Object)pathwayHashBuilder);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void saveStats(StatsPoint point) {
        this.savedStats = point;
    }

    @Override
    public StatsPoint getSavedStats() {
        return this.savedStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encode() throws IOException {
        this.lock.lock();
        try {
            if (!this.started) {
                throw new IllegalStateException("Context must be started to encode");
            }
            this.outputBuffer.clear();
            this.outputBuffer.writeLongLE(this.hash);
            long pathwayStartMillis = TimeUnit.NANOSECONDS.toMillis(this.pathwayStartNanos);
            VarEncodingHelper.encodeSignedVarLong(this.outputBuffer, pathwayStartMillis);
            long edgeStartMillis = pathwayStartMillis + TimeUnit.NANOSECONDS.toMillis(this.edgeStartNanoTicks - this.pathwayStartNanoTicks);
            VarEncodingHelper.encodeSignedVarLong(this.outputBuffer, edgeStartMillis);
            byte[] base64 = Base64.getEncoder().encode(this.outputBuffer.trimmedCopy());
            String string = new String(base64, StandardCharsets.ISO_8859_1);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            if (this.started) {
                String string = "PathwayContext[ Hash " + Long.toUnsignedString(this.hash) + ", Start: " + this.pathwayStartNanos + ", StartTicks: " + this.pathwayStartNanoTicks + ", Edge Start Ticks: " + this.edgeStartNanoTicks + ", objectHashcode:" + this.hashCode() + "]";
                return string;
            }
            String string = "PathwayContext [Not Started]";
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    static <C> DefaultPathwayContext extract(C carrier, CarrierVisitor<C> getter, TimeSource timeSource, long hashOfKnownTags, String serviceNameOverride) {
        PathwayContextExtractor pathwayContextExtractor = new PathwayContextExtractor(timeSource, hashOfKnownTags, serviceNameOverride);
        getter.forEachKeyValue(carrier, pathwayContextExtractor);
        if (pathwayContextExtractor.extractedContext == null) {
            log.debug("No context extracted");
        } else {
            log.debug("Extracted context: {} ", (Object)pathwayContextExtractor.extractedContext);
        }
        return pathwayContextExtractor.extractedContext;
    }

    private static DefaultPathwayContext decode(TimeSource timeSource, long hashOfKnownTags, String serviceNameOverride, String base64) throws IOException {
        byte[] base64Bytes = base64.getBytes(StandardCharsets.UTF_8);
        byte[] bytes = Base64.getDecoder().decode(base64Bytes);
        ByteArrayInput input = ByteArrayInput.wrap(bytes);
        long hash = input.readLongLE();
        long pathwayStartMillis = VarEncodingHelper.decodeSignedVarLong(input);
        long pathwayStartNanos = TimeUnit.MILLISECONDS.toNanos(pathwayStartMillis);
        long nowNanos = timeSource.getCurrentTimeNanos();
        long nanosSinceStart = nowNanos - pathwayStartNanos;
        long nowNanoTicks = timeSource.getNanoTicks();
        long pathwayStartNanoTicks = nowNanoTicks - nanosSinceStart;
        long edgeStartMillis = VarEncodingHelper.decodeSignedVarLong(input);
        long edgeStartNanoTicks = pathwayStartNanoTicks + TimeUnit.MILLISECONDS.toNanos(edgeStartMillis - pathwayStartMillis);
        return new DefaultPathwayContext(timeSource, hashOfKnownTags, pathwayStartNanos, pathwayStartNanoTicks, edgeStartNanoTicks, hash, serviceNameOverride);
    }

    public static long getBaseHash(WellKnownTags wellKnownTags) {
        UTF8BytesString processTags;
        StringBuilder builder = new StringBuilder();
        builder.append(wellKnownTags.getService());
        builder.append(wellKnownTags.getEnv());
        String primaryTag = Config.get().getPrimaryTag();
        if (primaryTag != null) {
            builder.append(primaryTag);
        }
        if ((processTags = ProcessTags.getTagsForSerialization()) != null) {
            builder.append(processTags);
        }
        return FNV64Hash.generateHash(builder.toString(), FNV64Hash.Version.v1);
    }

    private long generateNodeHash(PathwayHashBuilder pathwayHashBuilder) {
        return pathwayHashBuilder.getHash();
    }

    private long generatePathwayHash(long nodeHash, long parentHash) {
        this.outputBuffer.clear();
        this.outputBuffer.writeLongLE(nodeHash);
        this.outputBuffer.writeLongLE(parentHash);
        return FNV64Hash.generateHash(this.outputBuffer.backingArray(), 0, 16, FNV64Hash.Version.v1);
    }

    private static class PathwayHashBuilder {
        private long hash;

        public PathwayHashBuilder(long baseHash, String serviceNameOverride) {
            this.hash = baseHash;
            if (serviceNameOverride != null) {
                this.addTag(serviceNameOverride);
            }
        }

        public void addTag(String tag) {
            this.hash = FNV64Hash.continueHash(this.hash, tag, FNV64Hash.Version.v1);
        }

        public long getHash() {
            return this.hash;
        }
    }

    static class DataSetHashBuilder {
        private long currentHash = 0L;

        DataSetHashBuilder() {
        }

        public long addValue(String val) {
            this.currentHash = FNV64Hash.generateHash(this.currentHash + val, FNV64Hash.Version.v1);
            return this.currentHash;
        }
    }

    private static class PathwayContextExtractor
    implements BiConsumer<String, String> {
        private final TimeSource timeSource;
        private final long hashOfKnownTags;
        private final String serviceNameOverride;
        private DefaultPathwayContext extractedContext;

        PathwayContextExtractor(TimeSource timeSource, long hashOfKnownTags, String serviceNameOverride) {
            this.timeSource = timeSource;
            this.hashOfKnownTags = hashOfKnownTags;
            this.serviceNameOverride = serviceNameOverride;
        }

        @Override
        public void accept(String key, String value) {
            if ("dd-pathway-ctx-base64".equalsIgnoreCase(key)) {
                try {
                    this.extractedContext = DefaultPathwayContext.decode(this.timeSource, this.hashOfKnownTags, this.serviceNameOverride, value);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

